% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.tsd.R
\name{logLik.tsd}
\alias{logLik.tsd}
\title{Return Log Likelihood of a fit generated by tsd}
\usage{
\method{logLik}{tsd}(object, ...)
}
\arguments{
\item{object}{A result file generated by tsd}

\item{...}{Not used}
}
\value{
The Log Likelihood value of the fitted model and data
}
\description{
Return Log Likelihood of a fit generated by tsd
}
\details{
logLik.tsd Return Log Likelihood of a fit
}
\examples{
\dontrun{
library(embryogrowth)
m <- c(10, 14, 7, 4, 3, 0, 0)
f <- c(0, 1, 2, 4, 15, 10, 13)
t <- c(25, 26, 27, 28, 29, 30, 31)
result <- tsd(males=m, females=f, temperatures=t)
logLik(result)
AIC(result)
}
}
\author{
Marc Girondot
}
