% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R,
%   R/binary_method_functions.R, R/ordinal_method_functions.R,
%   R/continuous_method_functions.R
\name{plot_ML}
\alias{plot_ML}
\alias{plot_ML_binary}
\alias{plot_ML_ordinal}
\alias{plot_ML_continuous}
\title{Create plots visualizing the ML estimation process and results.}
\usage{
plot_ML(ML_est, params = NULL)

plot_ML_binary(
  ML_est,
  params = list(prev = NULL, se = NULL, sp = NULL, D = NULL)
)

plot_ML_ordinal(
  ML_est,
  params = list(pi_1_1 = NULL, phi_1ij_1 = NULL, phi_0ij_1 = NULL, D = NULL)
)

plot_ML_continuous(
  ML_est,
  params = list(prev_1 = NULL, mu_i1_1 = NULL, sigma_i1_1 = NULL, mu_i0_1 = NULL,
    sigma_i0_1 = NULL, D = NULL)
)
}
\arguments{
\item{ML_est}{A MultiMethodMLEstimate class object}

\item{params}{A list of population parameters. This is primarily used to evaluate
results from a simulation where the target parameters are known, but can be used to visualize
results with respect to some True value.}
}
\value{
A list of ggplot2 plots.

Binary:
\item{prev}{A plot showing how the prevalence estimate changes with each
iteration of the EM algorithm}
\item{se}{A plot showing how the sensitivity estimates of each method change with each
iteration of the EM algorithm}
\item{sp}{A plot showing how the specificity estimates of each method change with each
iteration of the EM algorithm}
\item{qk}{A plot showing how the q values for each observation k change
over each iteration of the EM algorithm}
\item{qk_hist}{A histogram of q values. Observations, k, can be colored by True
state if it is passed by \code{params$D}.}
\item{se_sp}{A plot showing the path the sensitivity and specificity estimates
for each method follows during the EM algorithm. True sensitivity and specificity
values can be passed by \code{params$se} and \code{params$sp}, respectively. This is useful
for comparing algorithm results when applied to simulation data where True parameter
values are known.}

Ordinal:
\item{ROC}{The Receiver Operator Characteristic (ROC) curves estimated for
each method}
\item{q_k1}{A plot showing how the q values for each observation, k, change when d=1
over each iteration of the EM algorithm. Observations can be colored by True
state if it is passed (\code{params$D}).}
\item{q_k0}{A plot showing how the q values for each observation, k, change when d=0
over each iteration of the EM algorithm. Observations can be colored by True
state if it is passed by \code{params$D}.}
\item{q_k1_hist}{A histogram of q_1 values. Observations, k, can be colored by True
state if it is passed by \code{params$D}.}
\item{phi_d}{A stacked bar graph representing the estimated CMFs of each
method when \code{d=0} and \code{d=1}.}

Continuous:
\item{ROC}{The Receiver Operator Characteristic (ROC) curves estimated for
each method}
\item{z_k1}{A plot showing how the z_k1 values for each observation change
over each iteration of the EM algorithm. Observations can be colored by True
state if it is passed (\code{params$D}).}
\item{z_k0}{A plot showing how the z_k0 values for each observation change
over each iteration of the EM algorithm. Observations can be colored by True
state if it is passed (\code{params$D}).}
\item{z_k1_hist}{A histogram of z_k1 values. Observations can be colored by True
state if it is passed (\code{params$D}).}
}
\description{
\code{plot_ML()} is a general function for visualizing results generated by \code{estimate_ML()}.
}
\examples{
# Set seed for this example
set.seed(11001101)

# Generate data for 4 binary methods
my_sim <- generate_multimethod_data(
  "binary",
  n_obs = 75,
  n_method = 4,
  se = c(0.87, 0.92, 0.79, 0.95),
  sp = c(0.85, 0.93, 0.94, 0.80),
  method_names = c("alpha", "beta", "gamma", "delta"))

# View the data
my_sim$generated_data

# View the parameters used to generate the data
my_sim$params

# Estimate ML accuracy values by EM algorithm
my_result <- estimate_ML(
  "binary",
  data = my_sim$generated_data,
  save_progress = FALSE # this reduces the data stored in the resulting object
)

# View results of ML estimate
my_result@results

}
