% Generated by roxygen2 (4.0.1): do not edit by hand
\name{p.value.survdiff}
\alias{p.value.survdiff}
\title{Extracts p-value from a logrank test}
\usage{
\method{p.value}{survdiff}(x, log.p = FALSE, ...)
}
\arguments{
\item{x}{Logrank test result, as returned by \code{\link[survival]{survdiff}}.}

\item{log.p}{Whether to return the logarithm of the p-value.}

\item{...}{Ignored. Kept for S3 consistency.}
}
\value{
p-value.
library(survival)
y <- Surv(time=1:100, event=rep(1:0, each=50))
groups <- rep(1:2, each=50)
x <- survdiff(y ~ groups)

# Compare p-values of implementations
print(x)
p.value(x)
}
\description{
Extracts p-value from a logrank test
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{p.value}}
}

