% Generated by roxygen2 (4.0.1): do not edit by hand
\name{outcome}
\alias{outcome}
\title{Create a vector of outcomes}
\usage{
outcome(time, event, levels, censor)
}
\arguments{
\item{time}{Time points at which an event occurred.}

\item{event}{The type of event that occurred. \code{NA} codes for no event.}

\item{levels}{Which levels of event to keep. Defaults to all unique
values of \code{event}.}

\item{censor}{What values of event should be considered censoring.
Defaults to \code{NA} and all values in \code{event} not present in
\code{levels}.}
}
\value{
A vector of outcomes.
}
\description{
Heavily modeled after the \code{\link{Surv}} class in the `survival` package.
Objects of this class are internally stored as data frames but should be
thought of as vectors and can be treated as such through out.
}
\examples{
outcome(runif(15), sample(c(NA, "Mechanical failure", "Out of fuel"), 15, TRUE))
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{factor.events}}, \code{\link{integer.events}},
  \code{\link{plot.outcome}}.
}

