% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interfacing.R, R/zzz.R, R/helpers.R,
%   R/0nly-internal.R, R/aovlist-support.R, R/emm-contr.R, R/countreg-support.R
\name{extending-emmeans}
\alias{extending-emmeans}
\alias{recover_data}
\alias{recover_data.call}
\alias{emm_basis}
\alias{.emm_register}
\alias{.std.link.labels}
\alias{.combine.terms}
\alias{.aovlist.dffun}
\alias{.cmpMM}
\alias{.get.excl}
\alias{.get.offset}
\alias{.my.vcov}
\alias{.all.vars}
\alias{.diag}
\alias{.num.key}
\alias{.emm_vignette}
\alias{.hurdle.support}
\alias{.zi.support}
\title{Support functions for model extensions}
\usage{
recover_data(object, ...)

\method{recover_data}{call}(object, trms, na.action, data = NULL,
  params = "pi", frame, pwts, addl.vars, ...)

emm_basis(object, trms, xlev, grid, ...)

.emm_register(classes, pkgname)

.std.link.labels(fam, misc)

.combine.terms(...)

.aovlist.dffun(k, dfargs)

.cmpMM(X, weights = rep(1, nrow(X)), assign = attr(X$qr, "assign"))

.get.excl(levs, exc, inc)

.get.offset(terms, grid)

.my.vcov(object, vcov. = .statsvcov, ...)

.all.vars(expr, retain = c("\\\\$", "\\\\[\\\\[", "\\\\]\\\\]", "'", "\\""),
  ...)

.diag(x, nrow, ncol)

.num.key(levs, key)

.emm_vignette(css = system.file("css", "clean-simple.css", package =
  "emmeans"), highlight = NULL, ...)

.hurdle.support(cmu, cshape, cp0, cmean, zmu, zshape, zp0)

.zi.support(zmu, zshape, zp0)
}
\arguments{
\item{object}{An object of the same class as is supported by a new method.}

\item{...}{Additional parameters that may be supported by the method.}

\item{trms}{The \code{\link{terms}} component of \code{object} (typically with
the response deleted, e.g. via \code{\link{delete.response}})}

\item{na.action}{Integer vector of indices of observations to ignore; or
\code{NULL} if none}

\item{data}{Data frame. Usually, this is \code{NULL}. However, if non-null,
this is used in place of the reconstructed dataset. It must have all of the
predictors used in the model, and any factor levels must match those used
in fitting the model.}

\item{params}{Character vector giving the names of any variables in the model
formula that are \emph{not} predictors. For example, a spline model may involve
a local variable \code{knots} that is not a predictor, but its value is
needed to fit the model. Names of parameters not actually used are harmless,
and the default value \code{"pi"} (the only numeric constant in base R)
is provided in case the model involves it. An example involving splines
may be found at \url{https://github.com/rvlenth/emmeans/issues/180}.}

\item{frame}{Optional \code{data.frame}. Many model objects contain the 
model frame used when fitting the model. In cases where there are no 
predictor transformations, this model frame has all the original predictor
values and so is usable for recovering the data. Thus, if \code{frame} is
non-missing and \code{data} is \code{NULL}, a check is made on \code{trms}
and if there are no function calls, we use \code{data = frame}. This
can be helpful because it provides a modicum of security against the
possibility that the original data used when fitting the model has been
altered or removed.}

\item{pwts}{Optional vector of prior weights. Typically, this may be obtained
from the fitted \code{model} via \code{weights(model)}. If this is provided,
it is used to set weights as long as it is non-\code{NULL} and the same length 
as the number of rows of the data.}

\item{addl.vars}{Character value or vector specifying additional predictors
to include in the reference grid. These must be names of variables that
exist, or you will get an error. 
This may be useful if you need to do
additional computations later on that depend on these variables; e.g., 
bias adjustments for random slopes of variables not among the fixed predictors.}

\item{xlev}{Named list of factor levels (\emph{excluding} ones coerced to 
factors in the model formula)}

\item{grid}{A \code{data.frame} (provided by \code{ref_grid}) containing 
the predictor settings needed in the reference grid}

\item{classes}{Character names of one or more classes to be registered.
The package must contain the functions \code{recover_data.foo} and
\code{emm_basis.foo} for each class \code{foo} listed in \code{classes}.}

\item{pkgname}{Character name of package providing the methods (usually
should be the second argument of \code{.onLoad})}

\item{fam}{Result of call to \code{family(object)}}

\item{misc}{A \code{list} intended for the \code{@misc} slot of an \code{emmGrid} object}

\item{k, dfargs}{Arguments to \code{.aovlist.dffun}, which is made available as a 
convenience to developers providing support similar to that provided for 
\code{aovlist} objects}

\item{X, weights, assign}{Arguments for \code{.cmpMM}, which compacts a model
matrix \code{X} into a much smaller matrix that has the same row space.
Specifically, it returns the R portion of its QR decomposition. If \code{X}
is already of class \code{qr}, it is used directly. \code{weights} should be
the weights used in the model fit, and \code{assign} is used for unravelling
any pivoting done by \code{\link{qr}}.}

\item{levs, key}{The \code{.num.key} function returns the numeric indices of
the levels in \code{levs} to the set of all levels in \code{key}}

\item{exc, inc}{Arguments for \code{.get.excl} which is useful
in writing \code{.emmc} functions for generating contrast coefficients,
and supports arguments \code{exclude} or \code{include} for excluding
or specifying which levels to use.}

\item{terms}{A \code{terms} component}

\item{vcov.}{Function or matrix that returns a suitable covariance matrix.
The default is \code{.statsvcov} which is \code{stats::vcov}. The \code{.my.vcov} 
function should be called in place of \code{\link{vcov}}, and it supports the user 
being able to specify a different matrix or function via the
optional \code{vcov.} argument.}

\item{expr, retain}{Arguments for \code{.all.vars}, which is an alternative to \code{\link{all.vars}}
that has special provisions for retaining the special characters in \code{retain},
thus allowing model specifications like \code{y ~ data$trt * df[["dose"]]}}

\item{x, nrow, ncol}{Arguments for \code{.diag}, which is an alternative to 
\code{\link{diag}} that lacks its idiosyncrasy of returning an
identity matrix when \code{x} is of length 1.}

\item{css, package, highlight}{Arguments for \code{.emm_vignette}, which is
a clean and simple alternative to such as \code{html_document} for use
as the output style of a Markdown file. All the vignettes in the
\pkg{emmeans} package use this output style.}

\item{cmu, zmu}{In \code{.hurdle.support} and \code{.zi.support}, 
these specify a vector of back-transformed 
estimates for the count and zero model, respectively}

\item{cshape, zshape}{Shape parameter for the count and zero model, respectively}

\item{cp0, zp0}{Function of \code{(mu, shape)} for computing Prob(Y = 0)
for the count and zero model, respectively}

\item{cmean}{Function of \code{(mu, shape)} for computing the mean of the
count model. Typically, this just returns \code{mu}}
}
\value{
The \code{recover_data} method must return a \code{\link{data.frame}}
  containing all the variables that appear as predictors in the model,
  and attributes \code{"call"}, \code{"terms"}, \code{"predictors"},
  and \code{"responses"}. (\code{recover_data.call} will 
  provide these attributes.)

The \code{emm_basis} method should return a \code{list} with the
  following elements:
\describe{
\item{X}{The matrix of linear functions over \code{grid}, having the same
  number of rows as \code{grid} and the number of columns equal to the length
  of \code{bhat}.}
\item{bhat}{The vector of regression coefficients for fixed effects. This
  should \emph{include} any \code{NA}s that result from rank deficiencies.}
\item{nbasis}{A matrix whose columns form a basis for non-estimable functions
  of beta, or a 1x1 matrix of \code{NA} if there is no rank deficiency.}
\item{V}{The estimated covariance matrix of \code{bhat}.}
\item{dffun}{A function of \code{(k, dfargs)} that returns the degrees of
  freedom associated with \code{sum(k * bhat)}.}
\item{dfargs}{A \code{list} containing additional arguments needed for
  \code{dffun}}.
} %%% end of describe

\code{.std.link.llabels} returns a modified version of \code{misc}
  with the appropriate information included corresponding to the information in \code{fam}

\code{combine.terms} returns a \code{terms} object resulting
  from combining all the terms or formulas in \code{...}.

\code{.get.offset} returns the values, based on \code{grid}, of 
any \code{offset} component in \code{terms}

\code{.hurdle.support} returns a matrix with 3 rows containing the
      estimated mean responses and the differentials wrt \code{cmu} and \code{zmu},
      resp.

\code{.zi.support} returns a matrix with 2 rows containing the
      estimated probabilities of 0 and the differentials wrt \code{mu}.
      See the section on hurdle and zero-inflated models.
}
\description{
This documents some functions and methods that may be useful to package 
developers wishing to add support for \pkg{emmeans} for their model objects.A user
or package developer may add \pkg{emmeans} support for a model
class by writing \code{recover_data} and \code{emm_basis} methods
for that class. (Users in need for a quick way to obtain results for a model
that is not supported may be better served by the \code{\link{qdrg}} function.)
There are several other exported functions that may be useful. See the
"xtending" vignette for more details.
}
\note{
Without an explicit \code{data} argument, \code{recover_data} returns
   the \emph{current version} of the dataset. If the dataset has changed
   since the model was fitted, then this will not be the data used to fit
   the model. It is especially important to know this in simulation studies
   where the data are randomly generated or permuted, and in cases where
   several datasets are processed in one step (e.g., using \code{dplyr}).
   In those cases, users should be careful to provide the actual data
   used to fit the model in the \code{data} argument.
}
\section{Details}{

To create a reference grid, the \code{ref_grid} function needs to reconstruct
the data used in fitting the model, and then obtain a matrix of linear
functions of the regression coefficients for a given grid of predictor
values. These tasks are performed by calls to \code{recover_data} and
\code{emm_basis} respectively. A vignette giving details and examples
is available via \href{../doc/xtending.html}{vignette("xtending", "emmeans")}

To extend \pkg{emmeans}'s support to additional model types, one need only
write S3 methods for these two functions. The existing methods serve as
helpful guidance for writing new ones.  Most of the work for
\code{recover_data} can be done by its method for class \code{"call"},
providing the \code{terms} component and \code{na.action} data as additional
arguments. Writing an \code{emm_basis} method is more involved, but the
existing methods (e.g., \code{emmeans:::emm_basis.lm}) can serve as models.
Certain \code{recover_data} and \code{emm_basis} methods are exported from
\pkg{emmeans}. (To find out, do \code{methods("recover_data")}.) If your
object is based on another model-fitting object, it
may be that all that is needed is to call one of these exported methods and
perhaps make modifications to the results. Contact the developer if you need
others of these exported.

If the model has a multivariate response, \code{bhat} needs to be
\dQuote{flattened} into a single vector, and \code{X} and \code{V} must be
constructed consistently.

In models where a non-full-rank result is possible (often, you can tell by
seeing if there is a \code{singular.ok} argument in the model-fitting
function), \code{\link{summary.emmGrid}} and its relatives check the
estimability of each
prediction, using the \code{\link[estimability]{nonest.basis}} function in
the \pkg{estimability} package.

The models already supported are detailed in \href{../doc/models.html}{the
"models" vignette}. Some packages may provide additional \pkg{emmeans}
support for its object classes.
}

\section{Communication between methods}{

If the \code{recover_data} method generates information needed by \code{emm_basis},
that information may be incorporated by creating a \code{"misc"} attribute in the
returned recovered data. That information is then passed as the \code{misc} 
argument when \code{ref_grid} calls \code{emm_basis}.
}

\section{Optional hooks}{

Some models may need something other than standard linear estimates and
standard errors. If so, custom functions may be pointed to via the items
\code{misc$estHook}, \code{misc$vcovHook} and \code{misc$postGridHook}. If
just the name of the hook function is provided as a character string, then it
is retrieved using \code{\link{get}}.

The \code{estHook} function should have arguments \samp{(object, do.se, tol,
...)} where \code{object} is the \code{emmGrid} object,
\code{do.se} is a logical flag for whether to return the standard error, and
\code{tol} is the tolerance for assessing estimability. It should return a
matrix with 3 columns: the estimates, standard errors (\code{NA} when
\code{do.se==FALSE}), and degrees of freedom (\code{NA} for asymptotic). The
number of rows should equal \samp{nrow(linfct(object)}. The
\code{vcovHook} function should have arguments \samp{(object, tol, ...)} as
described. It should return the covariance matrix for the estimates. Finally,
\code{postGridHook}, if present, is called at the very end of
\code{ref_grid}; it takes one argument, the constructed \code{object}, and
should return a suitably modified \code{emmGrid} object.
}

\section{Registering S3 methods for a model class}{

The \code{.emm_register} function is provided as a convenience to conditionally 
register your
S3 methods for a model class, \code{recover_data.foo} and \code{emm_basis.foo},
where \code{foo} is the class name. Your package should implement an
\code{.onLoad} function and call \code{.emm_register} if \pkg{emmeans} is
installed. See the example.
}

\section{Support for Hurdle and Zero-inflated models}{

  The functions \code{.hurdle.support} and \code{.zi.support} help facilitate
  calculations needed to estimate the mean response (count model and zero model
  combined) of these models. \code{.hurdle.support} returns a matrix of three rows.
  The first is the estimated mean for a hurdle model, and the 2nd and 3rd rows are
  differentials for the count and zero models, which needed for delta-method
  calculations. To use these, regard the \code{@linfct} slot as comprising
  two sets of columns, for the count and zero models respectively. To do
  the delta method calculations, multiply the rows of the count part by its 
  differentials times \code{link$mu.eta} evcaluated at that part of the linear predictor.
  Do the same for the zero part, using its differentials and \code{mu.eta}.
  If the resulting matrix is \bold{A}, then the covariance of the mean response
  is \bold{AVA'} where \bold{V}is the \code{@V} slot of the object.
  
  The function \code{zi.support} works the same way, only it is much simpler,
  and is used to estimate the probability of 0 and its differential for either 
  part of a zero-inflated model or hurdle model.
  
  See the code for \code{emm_basis.zeroinfl} and \code{emm_basis.hurdle}
  for how these are used with models fitted by the \pkg{pscl} package.
}

\examples{
\dontrun{
#--- If your package provides recover_data and emm_grid methods for class 'mymod',
#--- put something like this in your package code -- say in zzz.R:
  .onLoad <- function(libname, pkgname) {
    if (requireNamespace("emmeans", quietly = TRUE))
      emmeans::.emm_register("mymod", pkgname)
  }
}
}
\seealso{
\href{../doc/xtending.html}{Vignette on extending emmeans}
}
