% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.bipartite.R
\name{as.bipartite}
\alias{as.bipartite}
\title{Converts a network object (unipartite) to a two-mode (bipartite) network
representation.}
\usage{
as.bipartite(x = "network object", y = "membership vector")
}
\arguments{
\item{x}{A network object.}

\item{y}{A vector of membership values.}
}
\value{
Returns a matrix with the species of one mode arrayed in rows and
the other in columns.
}
\description{
Bipartite network approaches are often used for analyzing the
structure of interactions among species in communities.  Although
typically ecosystem networks are handled using a unipartite
representation, anlayzing them from a bipartite perspective may be
informative. This function provides an easy means for converting to
a bipartite representation as long as there is a natural division
to categorize species into distinct modes.
}
\examples{

data(oyster)
as.bipartite(oyster, gl(2, 3))

}
\author{
Matthew K. Lau
}
