% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalAUC.r
\name{evalAUC}
\alias{evalAUC}
\title{Weighted AUC}
\usage{
evalAUC(
  pres,
  contrast,
  presWeight = rep(1, length(pres)),
  contrastWeight = rep(1, length(contrast)),
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{pres}{Vector of predictions for "positive" cases (e.g., predictions at presence sites).}

\item{contrast}{Vector of predictions for "negative" cases (e.g., predictions at absence/background sites).}

\item{presWeight}{Weights of positive cases. The default is to assign each positive case a weight of 1.}

\item{contrastWeight}{Weights of contrast cases. The default is to assign each case a weight of 1.}

\item{na.rm}{Logical. If \code{TRUE} then remove any positive cases and associated weights and contrast predictions and associated weights with \code{NA}s.}

\item{...}{Other arguments (unused).}
}
\value{
A Numeric value.
}
\description{
This function calculates the area under the receiver-operator characteristic curve (AUC) following Mason & Graham (2002). Each case (presence/non-presence) can be assigned a weight, if desired.
}
\examples{
pres <- seq(0.5, 1, by=0.1)
contrast <- seq(0, 1, by=0.01)

# unweighted
evalAUC(pres, contrast)

# weighted (weight presences with low predictions more)
presWeight <- c(1, 1, 1, 0.5, 0.5, 0.5)
evalAUC(pres, contrast, presWeight=presWeight)

# weighted (weight presences with high predictions more)
presWeight <- c(0.5, 0.5, 0.5, 1, 1, 1)
evalAUC(pres, contrast, presWeight=presWeight)

# weight presences and absences
contrastWeight <- sqrt(contrast)
evalAUC(pres, contrast, presWeight=presWeight, contrastWeight=contrastWeight)
}
\references{
Mason, S.J. and N.E. Graham.  2002.  Areas beneath the relative operating characteristics (ROC) and relative operating levels (ROL) curves: Statistical significance and interpretation.  \emph{Quarterly Journal of the Royal Meteorological Society} 128:2145-2166. \doi{10.1256/003590002320603584}
}
\seealso{
\code{\link[predicts]{pa_evaluate}}, \code{\link{evalMultiAUC}}
}
