% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_importance.R
\name{plot_importance}
\alias{plot_importance}
\title{Plot variable importance}
\usage{
plot_importance(x, xlab = NULL, ylab = "Relative contribution",
                main = "Variable importance", extra_info = TRUE, ...)
}
\arguments{
\item{x}{data.frame output from \code{\link{var_importance}}.}

\item{xlab}{(character) a label for the x axis.}

\item{ylab}{(character) a label for the y axis.}

\item{main}{(character) main title for the plot.}

\item{extra_info}{(logical) when results are from more than one model, it
adds information about the number of models using each predictor and the mean
contribution found.}

\item{...}{additional arguments passed to \code{\link[graphics]{barplot}} or
\code{\link[graphics]{boxplot}}.}
}
\value{
A plot
}
\description{
Visualization of the results obtained with the function
\code{\link{var_importance}}.
}
\examples{

# Load species occurrences and environmental data.
data("enm_data", package = "enmpa")

# Custom formulas
forms <- c("Sp ~ bio_1 + I(bio_1^2) + I(bio_12^2)",
           "Sp ~ bio_12 + I(bio_1^2) + I(bio_12^2)")

# Fitting models
fits <- fit_glms(forms, data = enm_data)

# Variable importance for single models
vi_1 <- var_importance(fits$ModelID_1)
plot_importance(x = vi_1)

vi_2 <- var_importance(fits$ModelID_2)
plot_importance(x = vi_2)

# Variable importance for multiple models
vi_c <- var_importance(fits)
plot_importance(x = vi_c)
}
