% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_plot.R
\name{div_plot}
\alias{div_plot}
\title{Prepare an 'im' or 'raster' object for plotting with diverging color palette}
\usage{
div_plot(
  input,
  cols,
  midpoint = 0,
  thresh_up = NULL,
  thresh_low = NULL,
  digits = 1
)
}
\arguments{
\item{input}{An object of class 'im' or 'RasterLayer' from the \code{\link{lrren}} function.}

\item{midpoint}{Numeric. The value to center the diverging color palette.}

\item{thresh_up}{Numeric. The upper value to concatenate the color key. The default (NULL) uses the maximum value from \code{input}.}

\item{thresh_low}{Numeric. The lower value to concatenate the color key. The default (NULL) uses the minimum value from \code{input}.}

\item{digits}{Integer. The number of significant digits for the labels using the \code{\link[base]{round}} function (default is 1).}

\item{plot_cols}{Character string of length three (3) specifying the colors for plotting: 1) presence, 2) neither, and 3) absence from the \code{\link{plot_obs}} function.}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{v}}{An object of class 'vector' for the estimated ecological niche values.}
\item{\code{cols}}{An object of class 'vector', returns diverging color palette values.}
\item{\code{breaks}}{An object of class 'vector', returns diverging color palette breaks.}
\item{\code{at}}{An object of class 'vector', returns legend breaks.}
\item{\code{labels}}{An object of class 'vector', returns legend labels.}
}
}
\description{
Internal function to convert 'im' object or 'RasterLayer' object to values readable by \code{\link[fields]{image.plot}} function within the \code{\link{plot_obs}}, \code{\link{plot_predict}}, and \code{\link{plot_perturb}} functions.
}
\keyword{internal}
