% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{plotrtms}
\alias{plotrtms}
\title{Plot mass spectrum of certain retention time and return mass spectrum vector (MSP file) for NIST search}
\usage{
plotrtms(data, rt, ms, msp = FALSE)
}
\arguments{
\item{data}{imported data matrix of GC-MS}

\item{rt}{vector range of the retention time}

\item{ms}{vector range of the m/z}

\item{msp}{logical, return MSP files or not, default False}
}
\value{
plot, vector and MSP files for NIST search
}
\description{
Plot mass spectrum of certain retention time and return mass spectrum vector (MSP file) for NIST search
}
\examples{
\dontrun{
matrix <- getmd(rawdata)
plotrtms(matrix,rt = c(500,1000),ms = (300,500))
}
}
