% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{writeMSP}
\alias{writeMSP}
\title{Write MSP file for NIST search}
\usage{
writeMSP(list, name = "unknown", sep = FALSE)
}
\arguments{
\item{list}{a list with spectra information}

\item{name}{name of the compounds}

\item{sep}{numeric or logical the numbers of spectra in each file and FALSE to include all of the spectra in one msp file}
}
\value{
none a MSP file will be created.
}
\description{
Write MSP file for NIST search
}
\examples{
\dontrun{
ins <- c(10000,20000,10000,30000,5000)
mz <- c(101,143,189,221,234)
writeMSP(list(list(spectra = cbind.data.frame(mz,ins))), name = 'test')
}
}
