% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_library_default_pos.R
\name{set_library_default_pos}
\alias{set_library_default_pos}
\title{Modify default attach position for \code{base::library()}}
\usage{
set_library_default_pos(..., after = NULL, before = NULL, value = NULL)
}
\arguments{
\item{...}{Ignored. Arguments must be named}

\item{after, before}{string; the name of the environment on the search path
that library() calls should by default attach after or before.}

\item{value}{The value (or quoted expression) the new argument should be.}
}
\value{
The original default value of \code{pos}, invisibly
}
\description{
This function is documented but not exported. Reach in with
\code{envir:::set_library_default_pos()} to use it.
}
\details{
This is primarily a way to "pin" a particular environment on the
search path. For example, say you have a "project_utils" environment where
you've defined a variety of useful functions. To prevent future \code{library()}
calls from masking any objects in your attached "project_utils"
environment, you can modify the default \code{pos} argument to library.\if{html}{\out{<div class="sourceCode r">}}\preformatted{attach_source("project_utils.R", name = "project_utils)
set_library_default_pos(after = "project_utils")
library(foo) # now foo will attach after the "project_utils" environment
}\if{html}{\out{</div>}}
}
