% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sitrep.R
\name{sitrep}
\alias{sitrep}
\title{Output an environment status situation report}
\usage{
sitrep(silent = FALSE, path = "~/.envstat")
}
\arguments{
\item{silent}{boolean disables printed output}

\item{path}{path to the envstat config file}
}
\value{
TRUE/FALSE invisibly, to indicate all checks pass/fail
}
\description{
Reports on the availability of certain features of your compute
infrastructure, for example, environment variables, or a specific RStudio
Package Manager instance. Configure the tests with the \code{use_envstat} and
\code{edit_envstat} functions.
}
\examples{
\dontrun{
# By default envstat uses a config file in your home directory
envstat::sitrep()

# But you can tell it to use a different config file if you prefer
envstat::sitrep(path = "/tmp/config.yml")

# sitrep can also run silently, so that it can be used programatically
envstat::sitrep(silent = TRUE)
}
}
