% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{envvar_get_url}
\alias{envvar_get_url}
\alias{envvar_get_ipaddress}
\title{Environment variables for internet and network-related values}
\usage{
envvar_get_url(x, default = NULL, validate = NULL, warn_default = TRUE)

envvar_get_ipaddress(x, default = NULL, validate = NULL, warn_default = TRUE)
}
\arguments{
\item{x}{String containing an environment variable name}

\item{default}{Optional default value if the environment variable is not set}

\item{validate}{Optional function that checks a value for validity}

\item{warn_default}{Show a warning if the default value is used
(default: \code{TRUE})}
}
\value{
\code{envvar_get_url()} returns a URL: an S3 list with class \code{httr2_url}
and elements \code{scheme}, \code{hostname}, \code{port}, \code{path}, \code{fragment}, \code{query},
\code{username}, \code{password}, where applicable.

\code{envvar_get_ipaddress()} returns an \code{ip_address} vector
}
\description{
\code{envvar_get_url()} gets a URL value from an environment
variable and parses it with \link[httr2:url_parse]{httr2::url_parse}.

\code{envvar_get_ipaddress()} gets an IP address value from an
environment variable
}
\examples{

# Get a URL value and ensure that it is https
envvar_set("TEST_URL" = "https://google.com:80/?a=1&b=2")
envvar_get_url("TEST_URL", validate = \(x) x$scheme == "https")

# Get an IP address value and ensure that it is IPv4
envvar_set("TEST_HOST" = "192.168.1.15")
envvar_get_ipaddress("TEST_HOST", validate = ipaddress::is_ipv4)
}
