% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inFigure.R
\name{infigure}
\alias{infigure}
\title{import figures and extract the colors used in the figures}
\usage{
infigure(filename, format = NULL, exclude_col = NULL, topn = 10,
  showfig = FALSE, showcol = FALSE, savegg = FALSE, density = 300,
  pages = NULL)
}
\arguments{
\item{filename}{input filename}

\item{format}{format of input file}

\item{exclude_col}{vector of colors to be excluded from the analysis}

\item{topn}{display the most frequent colors}

\item{showfig}{display the figure or not (default: FALSE)}

\item{showcol}{display extracted colors or not (default: FALSE)}

\item{savegg}{save the figure as ggplot2 object or not (default: FALSE)}

\item{density}{resolution to render pdf}

\item{pages}{integer vector with page numbers (pdf file). Defaults to all pages.}
}
\description{
import figures and extract the colors used in the figures
}
\examples{
if(interactive()){
require(ggplot2)
p <- ggplot(mtcars, aes(mpg, disp, color = factor(cyl))) + geom_point()
tofigure(p,filename = file.path(tempdir(), "mtcars.pdf"))
pp <- infigure(filename = file.path(tempdir(), "mtcars.pdf"), exclude_col="white")
pp
}
}
\author{
Kai Guo
}
