% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.r
\name{ENgettimeparam}
\alias{ENgettimeparam}
\title{Get the value of one or more specific analysis time parameters.}
\usage{
ENgettimeparam(paramcode)
}
\arguments{
\item{paramcode}{A character string or integer specifying the parameter code
(see below).}
}
\value{
A named integer with the value of the specified time parameter.
}
\description{
\code{ENgettimeparam} retrieves the value of one or more specific analysis time parameters.
}
\details{
Time parameter codes consist of the following constants:
  \tabular{lll}{
  \code{EN_DURATION}     \tab   0  \tab    Simulation duration\cr
  \code{EN_HYDSTEP}      \tab   1  \tab    Hydraulic time step\cr
  \code{EN_QUALSTEP}     \tab   2  \tab    Water quality time step\cr
  \code{EN_PATTERNSTEP}  \tab   3  \tab    Time pattern time step\cr
  \code{EN_PATTERNSTART} \tab   4  \tab    Time pattern start time\cr
  \code{EN_REPORTSTEP}   \tab   5  \tab    Reporting time step\cr
  \code{EN_REPORTSTART}  \tab   6  \tab    Report starting time\cr
  \code{EN_RULESTEP}     \tab   7  \tab    Time step for evaluating rule-based controls\cr
  \code{EN_STATISTIC}    \tab   8  \tab    Type of time series post-processing used:\cr
                         \tab  	  \tab    0 = none\cr
                         \tab  	  \tab 	  1 = averaged\cr
                         \tab  	  \tab 	  2 = minimums\cr
                         \tab  	  \tab 	  3 = maximums\cr
                         \tab  	  \tab 	  4 = ranges\cr
  \code{EN_PERIODS}      \tab   9  \tab    Number of reporting periods saved to binary output file
  }
}
\examples{
# path to Net1.inp example file included with this package 
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp") 
ENopen(inp, "Net1.rpt")
ENgettimeparam("EN_DURATION")
ENgettimeparam("EN_HYDSTEP")
ENclose()
}
