% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/times.r
\name{ENsettimeparam}
\alias{ENsettimeparam}
\title{Set the value of a time parameter.}
\usage{
ENsettimeparam(paramcode, timevalue)
}
\arguments{
\item{paramcode}{An integer or character}

\item{timevalue}{An integer or character value of the time parameters in seconds.}
}
\description{
\code{ENsettimeparam} sets the value of a time parameter.
}
\details{
Time parameter codes consist of the following constants:

  \tabular{lrl}{
	 \code{EN_DURATION}		\tab	0	\tab	Simulation duration\cr
	 \code{EN_HYDSTEP}  	\tab	1	\tab	Hydraulic time step\cr
	 \code{EN_QUALSTEP}		\tab	2	\tab	Water quality time step\cr
  \code{EN_PATTERNSTEP}	\tab	3	\tab	Time pattern time step\cr
  \code{EN_PATTERNSTART}	\tab	4	\tab	Time pattern start time\cr
	 \code{EN_REPORTSTEP}	\tab	5	\tab	Reporting time step\cr
	 \code{EN_REPORTSTART}	\tab	6	\tab	Reporting starting time\cr
	 \code{EN_RULESTEP}		\tab	7	\tab	Time step for evaluating rule-based controls\cr
	 \code{EN_STATISTIC}	\tab	8	\tab	Type of time series post-processing to use:\cr
							\tab		\tab	\code{EN_NONE} (0) = none\cr
							\tab		\tab	\code{EN_AVERAGE} (1) = averaged\cr
							\tab		\tab	\code{EN_MINIMUM} (2) = minimums\cr
							\tab		\tab	\code{EN_MAXIMUM} (3) = maximums\cr
							\tab		\tab	\code{EN_RANGE} (4) = ranges
  }

  Do not change time parameters after calling ENinitH in a hydraulic analysis or 
  \code{ENinitQ} in a water quality analysis
}
\examples{
# path to Net1.inp example file included with this package 
inp <- file.path( find.package("epanet2toolkit"), "extdata","Net1.inp") 
ENopen(inp, "Net1.rpt")
ENgettimeparam("EN_HYDSTEP")
ENsettimeparam("EN_HYDSTEP", 600)
ENgettimeparam("EN_HYDSTEP")
ENclose()
}
