% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{cases_pal}
\alias{cases_pal}
\alias{spectral}
\alias{char2col}
\alias{transp}
\title{Color tools and palettes for epicontacts}
\usage{
cases_pal(n)

spectral(n)

char2col(x, pal = cases_pal, NA_col = "lightgrey")

transp(col, alpha = 0.5)
}
\arguments{
\item{n}{An integer indicating the number of colors.}

\item{x}{A character or a factor to be converted to colors.}

\item{pal}{A color palette.}

\item{NA_col}{The color to be used for NA values.}

\item{col}{A color vector to which transparency should be added.}

\item{alpha}{The threshold to be used for transparency: 0 for full
transparency, and 1 for full opacity.}
}
\description{
These functions are used for defining palettes or colors in the
\code{epicontacts} package. They include:
}
\details{
\itemize{

\item \code{cases_pal}: discrete color palette used for cases (comes from the
\code{dibbler} package)

\item \code{spectral}: continuous color palette (comes from the
\code{adegenet} package)

\item \code{transp}: makes colors transparent (comes from the
\code{adegenet} package)

\item \code{char2col}: translates a character or a factor to a color using a
palette (comes from the \code{adegenet} package)

}
}
\examples{

barplot(1:5, col = cases_pal(5))
barplot(1:50, col = cases_pal(50))

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
