% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.r
\name{get_black_white_wage_gap}
\alias{get_black_white_wage_gap}
\title{Retreive the percent by which hourly wages of black workers are less than hourly wages of white workers}
\usage{
get_black_white_wage_gap(by = NULL)
}
\arguments{
\item{by}{\code{NULL} or \code{g} for a parition by gender}
}
\value{
\code{tbl_df} with data filtered by the selected criteria.
}
\description{
The black-white wage gap is the percent by which hourly wages of black workers are less
than hourly wages of white workers. It is also often expressed as a wage ratio (black
workers' share of white workers' wages) by subtracting the gap from 100 percent.
}
\details{
\itemize{
\item{A median black-white wage gap of 26.2 percent means that a typical black worker
      is paid 26.2 percent less per hour than a typical white worker.}
\item{An average black-white wage gap of 26.6 percent means that on average black
      workers are paid 26.6 percent less per hour than white workers.}
\item{A regression-based black-white wage gap of 15.2 percent means that on average
      black workers are paid 15.2 percent less per hour than white workers, all else
      held equal (controlling for gender, race and ethnicity, education, experience,
      and geographic location).}
}
}
\examples{
get_black_white_wage_gap()

get_black_white_wage_gap("g")
}
\references{
\href{http://www.epi.org/data/}{Economic Policy Institute Data Library}
}

