% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_epi.R
\name{plot_infectious}
\alias{plot_infectious}
\alias{plot_infectious.epimodel}
\title{Plot total infectiousness over time.}
\usage{
plot_infectious(object, ...)

\method{plot_infectious}{epimodel}(
  object,
  groups = NULL,
  dates = NULL,
  date_breaks = "2 weeks",
  date_format = "\%Y-\%m-\%d",
  levels = c(30, 60, 90),
  by_100k = FALSE,
  log = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{...}{Additional arguments for
\code{\link{posterior_infectious}}. Examples include
\code{newdata}, which allows predictions or counterfactuals.}

\item{groups}{Either \code{NULL} or a character vector specifying the groups
to plot for. Default is \code{NULL}, which plots all modeled groups.}

\item{dates}{A length 2 vector of \code{Date} objects. This defines the
start and end dates of the date-range to be plotted. Must be coercible to
\code{Date} if not \code{NA}. If an element of the vector is \code{NA} then
the default lower/upper limit is used. See examples.}

\item{date_breaks}{A string giving the distance between date tick labels.
Default is \code{"2 weeks"}. This is passed as the \code{date_breaks} argument to
\code{\link[ggplot2]{scale_x_date}}. Please see \href{https://ggplot2.tidyverse.org/reference/scale_date.html}{here} for details.}

\item{date_format}{This function attempts to coerce the \code{dates} argument
to a vector of \code{Date} objects. \code{date_format} is passed as the \code{format}
argument to \code{\link[base]{as.Date}}. Default is "\%Y-\%m-\%d".}

\item{levels}{A numeric vector defining the levels of the plotted
credible intervals.}

\item{by_100k}{If \code{TRUE}, all quantities are plotted per 100k of population. Only possible if the model used a population adjustment.}

\item{log}{If \code{TRUE}, plot quantities on a log10-scale. This argument
must be \code{logical}, and defaults to \code{FALSE}.}
}
\value{
A \code{ggplot} object which can be further modified.
}
\description{
Plots credible intervals and the median for total infectiousness over time. This is
basically a weighted sum of all infected individuals. Each infected individual is weighted
by how infectious they are expected to be given how long they have been infected for. The user can
control the interval levels (i.e. 30\%, 50\% etc.) and the plotted group(s).
This is a generic function.
}
\examples{
\donttest{
data("EuropeCovid2")
data <- EuropeCovid2$data
data <- dplyr::filter(data, date > date[which(cumsum(deaths) > 10)[1] - 30])
data <- dplyr::filter(data, date < as.Date("2020-05-05"))

rt <- epirt(
  formula = R(country, date) ~ 0 + (1 + public_events + schools_universities + 
     self_isolating_if_ill + social_distancing_encouraged + lockdown || country) + 
     public_events + schools_universities + self_isolating_if_ill + 
     social_distancing_encouraged + lockdown,
  prior = shifted_gamma(shape=1/6, scale = 1, shift = log(1.05)/6),
  prior_covariance = rstanarm::decov(shape = c(2, rep(0.5, 5)),scale=0.25),
  link = scaled_logit(6.5)
)

inf <- epiinf(gen = EuropeCovid$si, seed_days = 6)

deaths <- epiobs(
  formula = deaths ~ 1,
  i2o = EuropeCovid2$inf2death,
  prior_intercept = rstanarm::normal(0,0.2),
  link = scaled_logit(0.02)
)

args <- list(rt=rt, inf=inf, obs=deaths, data=data, seed=12345)
args$group_subset <- c("Italy", "Austria", "Germany")
args$algorithm <- "fullrank"
args$iter <- 1e4
args$tol_rel_obj <- 1e-3

fm <- do.call(epim, args)

# different ways of using plot_rt
p <- plot_rt(fm) # default, plots all groups and dates
p <- plot_rt(fm, dates=c("2020-03-21", NA)) # plot 21 March 2020 onwards
p <- plot_rt(fm, dates=c(NA, "2020-03-20")) # plot up to  20 March 2020
p <- plot_rt(fm, dates=c("2020-03-20", "2020-04-20"))
p <- plot_rt(fm,
         dates=c("2020-03-20", "2020-04-20"),
        date_breaks="1 day") # ticks every day
p <- plot_rt(fm,
       dates=c("2020-20-03", "2020-20-04"),
       date_format="\%Y-\%d-\%m") # (different date format)

# other plotting functions
p <- plot_obs(fm, type = "deaths")
p <- plot_infections(fm)
p <- plot_infectious(fm) 
}
}
\seealso{
\code{\link{plot_rt}}, \code{\link{plot_obs}}, \code{\link{plot_infections}}, \code{\link{posterior_infectious}}
}
