% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{plot_metrics}
\alias{plot_metrics}
\title{Plot CRPS, Median/Mean Absolute Error}
\usage{
plot_metrics(object, groups = NULL, type, metrics = NULL, newdata = NULL)
}
\arguments{
\item{object}{A fitted model object returned by \code{\link{epim}}.
See \code{\link{epimodel-objects}}.}

\item{groups}{Either \code{NULL} or a character vector specifying the groups
to plot for. Default is \code{NULL}, which plots all modeled groups.}

\item{type}{A string specifying the name of the observations to plot. This should match one
of the names of the response variables in the \code{obs} argument used int the call to \code{\link{epim}}.}

\item{metrics}{A string or character vector specifying the plotted
forecast error metrics. One of \code{NULL}, \code{"crps"},
\code{"mean_abs_error"}}

\item{newdata}{If provided, the original \code{data} used
in \code{object} is overridden. Useful for forecasting}
}
\value{
A \code{ggplot} object which can be further modified.
}
\description{
Plots various metrics for evaluating probabilistic forecasts by group.
}
