% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertFromFactor.R
\name{convertFromFactor}
\alias{convertFromFactor}
\title{Convert factor variable to numeric or character variable.}
\usage{
convertFromFactor(data = NULL, numeric = c(""), character = c(""),
  mode = c("automatic", "only_specified", "all_character", "all_numeric"))
}
\arguments{
\item{data}{a data.frame which contains factor variables.}

\item{numeric}{a character vector specifying variable names to be converted into numeric variables.}

\item{character}{a character vector specifying variable names to be converted into character variables.}

\item{mode}{a character vector specifying converting mode. See details and the default is \sQuote{only_specified}.}
}
\value{
a converted data.frame.
}
\description{
Convert factor variable to numeric or character variable.
}
\details{
This function convert factor variable to numeric or character variable. In \sQuote{automatic} mode, all variables not specified by numeric or character arguments are converted into numeric or character automatically. Explicitly specified variables are converted as specified. In \sQuote{only_specified} mode, variables specified by numeric argument is converted into numeric variables, and the character is conveted into character variables. When converted into numeric variable, NAs can be produced for incompatible data with warnings. In \sQuote{all_character}, and \sQuote{all_numeric} modes, all factor variables are converted into character or numeric variables, respectively.
}
\examples{
a <- factor(rnorm(5))
b <- c("a", "b", "c", "d", "e")
c <- c("1", "2", "3", "4", NA)
d <- c("1", "2", "3", "4", ".")
dat <- data.frame(a,b,c,d)
dat2 <- convertFromFactor(dat)
dat3 <- convertFromFactor(dat, numeric=c("d"))
dat4 <- convertFromFactor(dat, mode="all_character")
}
\seealso{
\code{\link{showContents}}, \code{\link{listNumericIncompatibility}}
}

