% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\name{plot.EpiNet}
\alias{plot.EpiNet}
\title{Plot epistatic network.}
\usage{
\method{plot}{EpiNet}(x, ...)
}
\arguments{
\item{x}{an object of class \code{'EpiNet'}.}

\item{...}{additional parameters (ignored)}
}
\value{
A plot of the epistatic network is displayed.
}
\description{
Plot an epistatic network between a set of QTLs.
}
\details{
An object of class \code{EpiNet} is typically first retrieved from
a \code{Population} object (using \code{\link{getEpiNet}}) before
being plotted using \code{plot.EpiNet()}.
}
\examples{
# Build a population with an epistatic network attached
pop <- Population(
  popSize = 100, map = map100snp, QTL = 20,
  alleleFrequencies = runif(100), broadH2 = 0.9,
  narrowh2 = 0, traitVar = 40
)
pop <- attachEpiNet(pop)

# Retrieve and plot the epistatic network
epinet <- getEpiNet(pop)
plot(epinet)
}
\seealso{
\code{\link{Population}}, \code{\link{attachEpiNet}},
  \code{\link{getEpiNet}}
}
\author{
Dion Detterer, Paul Kwan, Cedric Gondro
}
