% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/final_size.R
\name{R02herd_immunity_threshold}
\alias{R02herd_immunity_threshold}
\title{Title Calculate herd immunity threshold from basic reproduction number}
\usage{
R02herd_immunity_threshold(R0)
}
\arguments{
\item{R0}{a value or vector of values representing the basic reproduction 
number, must be >=0}
}
\value{
The herd immunity threshold, calculated as 1 - 1 / R0
}
\description{
Title Calculate herd immunity threshold from basic reproduction number
}
\examples{

## Calculate the herd immunity threshold for a specific value of the 
## reproduction number (here 2)
R02herd_immunity_threshold(2) 

## plot the relationship between R0 and herd immunity threshold
x <- seq(1.01, 15, 0.01)
plot(x, R02herd_immunity_threshold(x), type = "l", 
  xlab = "R0", ylab = "Herd immunity threshold")

}
