% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impl-idf.R
\name{make_idf_object_name}
\alias{make_idf_object_name}
\title{Initialize object data}
\usage{
make_idf_object_name(
  idd_env,
  idf_env,
  dt_object,
  use_old = TRUE,
  prefix_col = NULL,
  prefix_sep = " ",
  keep_na = TRUE,
  include_ori = FALSE
)
}
\arguments{
\item{idd_env}{An environment or list contains IDD tables including class,
field, and reference.}

\item{idf_env}{An environment or list contains IDF tables including object,
value, and reference.}

\item{dt_object}{A \code{\link[data.table:data.table]{data.table::data.table()}} containing object data.}

\item{use_old}{If \code{TRUE}, new object names are based on the original object
names in column \code{object_name}. If \code{FALSE}, new object names are
created based on the class name it belongs to. Default: \code{TRUE}.}

\item{prefix_col}{An character vector of column names in input \code{dt_object}
whose values will be combined together as the prefix of the new object
names. Default: \code{NULL}.}

\item{prefix_sep}{A single string specifying the separation character among
prefix columns. Default: \code{NULL}.}

\item{keep_na}{If \code{TRUE}, new object names will be \code{NA} if the original
object names in column \code{object_name} are \code{NA}s. Default: \code{TRUE}.}

\item{include_ori}{If \code{TRUE}, make sure new object names are not the same as
the original object names in the \code{object_name} column. Default: \code{FALSE}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}}
}
\description{
Initialize object data
}
\keyword{internal}
