% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idf_object.R
\docType{class}
\name{idf_object}
\alias{idf_object}
\title{EnergyPlus IDF object}
\description{
\code{IdfObject} is an abstraction of a single object in an \code{Idf}. It provides
more detail methods to modify objects. \code{IdfObject} can only be created from
the parent \code{Idf} object, using \code{$object}, \code{$object_in_class()} and
\code{$search_object()}. This is because that initialization of an \code{IdfObject}
needs some shared data from parent \code{Idf} object.
}
\section{Usage}{

\preformatted{
idfobj$id()
idfobj$name()
idfobj$definition()
idfobj$get_comment()
idfobj$set_comment(comment, append = TRUE, width = 0L)
idfobj$get_value(which = NULL, all = NULL, simplify = FALSE)
idfobj$set_value(..., defaults = TRUE)
idfobj$FieldName
idfobj[[Field]]
idfobj$FieldName <- Value
idfobj[[Field]] <- Value
idfobj$possible_value(which = NULL)
idfobj$validate()
idfobj$is_valid()
idfobj$ref_from_object()
idfobj$ref_by_object()
idfobj$has_ref_by()
idfobj$has_ref_from()
idfobj$has_ref()
idfobj$table(all = FALSE, unit = TRUE, wide = FALSE, string_value = TRUE, in_ip = eplusr_option("view_in_ip"))
idfobj$string(comment = TRUE, leading = 4L, sep_at = 29L)
idfobj$print(comment = TRUE, auto_sep = FALSE)
print(iddobj)
}
}

\section{Basic Info}{
\preformatted{idfobj$id()
idfobj$name()
idfobj$group_name()
idfobj$class_name()
}

\code{$id()} returns the object ID.

\code{$name()} returns the object name. If the class does not have name
attribute, then \code{NA} will returned.

\code{$group_name()} returns the group name of this object belongs to.

\code{$class_name()} returns the class name of this object belongs to.
}

\section{Definition}{
\preformatted{idfobj$definition()
}

\code{$definition()} returns the definition, i.e. the \code{IddObject}, of current
class. For details of \code{IddObject}, please see \link[=idd_object]{IddObject class}.
}

\section{Comment}{
\preformatted{idfobj$get_comment()
idfobj$set_comment(comment, append = TRUE, width = 0L)
}

\code{$get_comment()} returns the comments of current object.

\code{$set_comment()} sets comments of current object.

\strong{Arguments}
\itemize{
\item \code{comment}: A character vector.
\item \code{append}: If \code{TRUE}, comment will be appended to existing comments. If
\code{FALSE}, comment will be prepended to existing currents. If \code{NULL},
existing comments will be deleted. Default: \code{FALSE}
\item \code{width}: An integer to indicate where to break long comment lines. If \code{0},
no breaking will be made.
}
}

\section{Value}{

\preformatted{
idfobj$get_value(which = NULL, all = FALSE, simplify = FALSE)
idfobj$set_value(..., default = TRUE)
idfobj$FieldName
idfobj[[Field]]
idfobj$FieldName <- Value
idfobj[[Field]] <- Value
idfobj$possible_value(which = NULL)
}

\code{$get_value()} returns a named list containing values of specified fields.
If simplify is \code{FALSE}, then all values will be converted into character
and the converted character vector will be returned. Note that the field
names will be converted into valid R names, i.e. all characters other
than letters and numbers will be replaced by underscore("_").

\code{$set_value()} sets values of current object.

eplusr also provides custom S3 method of \code{$}, \code{[[} and also \code{$<-} and
\code{[[<-} to make it more convenient to get and set a single value of an
\code{IdfObject}. Basically, \code{idfobj$FieldName} and \code{idfobj[[Field} is equivalent to \code{idfobj$get_value(Field)[[1]]};
\code{idfobj$FieldName <- Value} and \code{idfobj[[Field]] <- Value} is equivalent
to \code{idfobj$set_value(Field = Value)},  where \code{FieldName} is a single valid
field name and \code{Field} is a single valid field index or name.

\code{$possible_value()} return all possible values for specified fields,
including auto-value (\code{autosize} and \code{autocalculate}), default value,
value range, choices and references. Underneath, it returns a data.table
with custom printing method.

\strong{Arguments}
\itemize{
\item \code{which}: An integer vector of field indexes or a character vector of field
names. Field names can be given in "lower-style", e.g. \code{"Thermal Resistance"} can be given as \code{"thermal_resistance"}.
\item \code{all}: If \code{TRUE}, values of all fields, including empty fields will be
returned as well. Default: \code{FALSE}
\item \code{simplify}: If \code{TRUE}, values of fields will be converted into characters
and the converted character vector will be returned.
\item \code{...}: Values to set. Field names of value can be given. If not named, the
input values will be set to fields according to their order of
appearance.
\item \code{default}: If \code{TRUE}, all empty fields will be filled with their default
values if possible.
\item \code{FieldName}: A single length character vector of one valid field name where
all characters except letters and numbers are replaced by underscores.
\item \code{Field}: A single length character vector of one valid field name or a
single length integer vector of one valid field index. Same as above,
field names should be given in a style where all characters except
letters and numbers are replaced by underscores.
\item \code{Value}: A single length vector of value to set.
}
}

\section{Validation}{
\preformatted{idfobj$validate()
idfobj$is_valid()
}

\code{$validate()} will check if there are errors in current object under different
strictness level.

\code{$is_valid()} will check if there are no errors in current object under
different strictness level.

The strictness level can be changed using \code{\link[=eplusr_option]{eplusr_option()}}. Default is
\code{"final".}There are three different validate levels, i.e. \code{"none"},
\code{"draft"} and \code{"final"}:
\itemize{
\item For \code{"none"}, none validation will be done;
\item For \code{"draft"}, checking of invalid autosize, autocalculate, numeric,
integer, and choice field values will be done;
\item For \code{"final"}, besides above, checking of missing required objects,
duplicated unique objects, object name conflicts, missing required
fields and invalid field value reference will also be done.
}
}

\section{Cross Reference}{
\preformatted{idfobj$ref_from_object()
idfobj$ref_by_object()
idfobj$has_ref_from()
idfobj$has_ref_by()
idfobj$has_ref()
}

\code{$ref_from_object()} will return other objects that current object references
from.

\code{$ref_by_object()} will return other objects that reference current object.

\code{$has_ref_from()} and \code{$has_ref_by} will return \code{TRUE} if current object has
referenced from other objects or has been referenced by other objects,
respectively.

\code{$has_ref()} will return \code{TRUE} if current object has either referenced from
other objects or has been referenced by other objects.
}

\section{Data Extraction}{
\preformatted{idfobj$table(all = FALSE, unit = TRUE, wide = FALSE, string_value = TRUE, in_ip = eplusr_option("view_in_ip"))
}

\code{$table()} will return a data.table that contains all data of current object.

\strong{Arguments}
\itemize{
\item \code{all}: If \code{TRUE}, values of all fields, including empty fields will be
returned as well. Default: \code{FALSE}
\item \code{unit}: If \code{TRUE}, field names with units will be returned. Default:
\code{TRUE}.
\item \code{wide}: If \code{TRUE}, a wide table will be returned. Default: \code{FALSE}.
\item \code{string_value}: If \code{TRUE}, all field values will be returned as character.
Default: \code{TRUE}
\item \code{in_ip}: If \code{TRUE}, IP units and values will be returned. Default: the
value of \code{eplusr_option("view_in_ip")}.
}
}

\section{Formatting}{
\preformatted{idfobj$string(comment = TRUE, leading = 4L, sep_at = 29L)
}

\code{$string()} will return the text format of current object.

\strong{Arguments}
\itemize{
\item \code{comment}: If \code{FALSE}, all comments will not be included.
\item \code{leading}: An integer to indicate the number of spaces before each fields.
Default: \code{4}.
\item \code{sep_at}: An integer to indicate the character width where to separate
values and field names.  Default: \code{29}.
}
}

\section{Print}{
\preformatted{idfobj$print(comment = TRUE, auto_sep = FALSE)
print(idfobj)
}

\strong{Arguments}
\itemize{
\item \code{comment}: If \code{FALSE}, all comments will not be included.
\item \code{auto_sep}: If \code{TRUE}, values and field names will be separate at the
largest character length of values. Default: \code{FALSE}.
}
}

\seealso{
\link[=idf]{Idf class}
}
\author{
Hongyuan Jia
}
