% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{eq5d}
\alias{eq5d}
\title{Calculate EQ-5D index scores}
\usage{
eq5d(scores, version, type, country, ignore.invalid, ...)
}
\arguments{
\item{scores}{numeric or data.frame with names/colnames MO, SC, UA, PD and AD
representing Mobility, Self-care, Usual activities, Pain/discomfort and
Anxiety/depression. Alternatively an EQ-5D  score can be provided in
five digit format e.g. 12321.}

\item{version}{string of value "3L", "5L" or "Y" to indicate instrument
version.}

\item{type}{string specifying method type used in deriving value set scores.
Options are TTO or VAS for EQ-5D-3L, VT for EQ-5D-5L, CW for EQ-5D-5L
crosswalk conversion valuesets, RCW for EQ-5D-3L reverse crosswalk 
conversion valuesets and DSU for the NICE Decision Support Unit age-sex
based EQ-5D-3L to EQ-5D-5L and EQ-5D-5L to EQ-5D-3L mappings}

\item{country}{string of value set country name used.}

\item{ignore.invalid}{logical to indicate whether to ignore dimension data
with invalid, incomplete or missing data.}

\item{...}{character vectors for column names when using a data.frame. Use 
"dimensions" (default c("MO", "SC", "UA", "PD" and "AD")), "five.digit" 
(default "State") or "utility", "age", "sex" and "bwidth" (defaults 
"Utility", "Age", "Sex" and "bwidth") for NICE DSU mapping. When a single 
NICE DSU score is being calculated "age", "sex" and "bwidth" are also 
used. See \code{\link{eq5dmap}} for valid options.}
}
\value{
a numeric vector of utility index scores.
}
\description{
Wrapper for \code{eq5d3l} and \code{eq5d5l}. Calculate EQ-5D index scores for
EQ-5D-3L and EQ-5D-5L. Available value sets can be viewed using the function
\code{valuesets}.
}
\examples{
eq5d(scores=c(MO=1,SC=2,UA=3,PD=4,AD=5), type="VT",
 country="Indonesia", version="5L")
eq5d(scores=c(MO=3,SC=2,UA=3,PD=2,AD=3),
 type="TTO", version="3L", country="Germany")
 
eq5d(0.922, country="UK", version="5L", type="DSU", 
 age=18, sex="male")

scores.df <- data.frame(
  MO=c(1,2,3,4,5), SC=c(1,5,4,3,2),
  UA=c(1,5,2,3,1), PD=c(1,3,4,3,4), AD=c(1,2,NA,2,1)
  )
eq5d(scores.df, country="Canada", version="5L", type="VT", ignore.invalid=TRUE)

eq5d(scores=12321, type="TTO", version="3L", country="UK")

scores.df2 <- data.frame(
  state=c(11111,12121,23232,33333)
)

eq5d(scores=scores.df2, type="TTO", version="3L", country="UK", five.digit="state")

eq5d(scores=scores.df2$state, type="TTO", version="3L", country="UK")

}
