% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yr.R
\name{yr_era}
\alias{yr_era}
\alias{yr_set_era}
\alias{yr_era<-}
\title{Get or set the era of a vector of years}
\usage{
yr_era(x)

yr_set_era(x, era)

yr_era(x) <- value
}
\arguments{
\item{x}{A vector of years.}

\item{value, era}{An \code{era} object (see \code{\link[=era]{era()}}) to be assigned to \code{x}.}
}
\value{
\code{yr_era(x)} returns the existing era associated with \code{x}.

\code{yr_set_era(x, era)} and \code{yr_era(x) <- era} return \code{x} with the new era
assigned. If \code{x} is not already a \code{yr} vector, it will attempt to coerce it
into one.
}
\description{
Functions for extracting or assigning the era of a vector of years.
This function does not alter the underlying values of \code{x}. Use \code{\link[=yr_transform]{yr_transform()}}
to \emph{convert} the values of a \code{yr} vector to a new era.
}
\examples{
x <- 5000:5050
yr_era(x) <- era("cal BP")
yr_era(x)
}
\seealso{
Other years with era functions: 
\code{\link{yr_transform}()},
\code{\link{yr}()}
}
\concept{years with era functions}
