% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-date.R
\name{this_year}
\alias{this_year}
\title{Current year}
\usage{
this_year(era = "CE")
}
\arguments{
\item{era}{An \code{era} object or label understood by \code{\link[=era]{era()}}. Defaults to the
Common Era (\code{era("CE")}).}
}
\value{
A \code{yr} vector with the current year.
}
\description{
Returns the current year as a year vector, in the era system specified by
\code{era}.
}
\examples{
# This year in the Common Era
this_year()
# This year in the Holocene Epoch
this_year("HE")
}
\seealso{
Other era helper functions: 
\code{\link{era_parameters}},
\code{\link{era_year_parameters}},
\code{\link{era_year}},
\code{\link{era}},
\code{\link{is_era_year}()},
\code{\link{is_era}()},
\code{\link{is_yr}()}
}
\concept{era helper functions}
