% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EgoStat.R
\docType{methods}
\name{ergm.ego-terms}
\alias{ergm.ego-terms}
\alias{terms-ergm.ego}
\alias{ergm.ego.terms}
\alias{terms.ergm.ego}
\alias{ergm-terms}
\alias{ergm.terms}
\alias{terms-ergm}
\alias{terms.ergm}
\alias{EgoStat}
\title{\code{\link[ergm:ergm]{ergm()}} Terms Implemented for
\code{\link[egor:egor]{egor}}}
\description{
This page describes the \code{\link[ergm:ergm]{ergm()}} terms (and hence network
statistics) for which inference based on egocentrically sampled data is
implemented in \CRANpkg{ergm.ego} package. Other packages may add their own
terms. These functions should not be called by the end-user.
}
\details{
The current recommendation for any package implementing additional
egocentric calculator terms is to create a help file with a name or alias
\code{\link{ergm.ego-terms}}, so that \code{help("ergm.ego-terms")} will
list egocentric ERGM terms available from all loaded packages.
}
\section{Currently implemented egocentric statistics}{
 For each of these,
please see their respective package's \code{ergm-terms} help for meaning and
parameters. The simplest way to do this is usually via \code{? TERM}.

\describe{ \item{Special-purpose terms:}{ \describe{
\item{netsize.adj(edges=+1, mutual=0, transitiveties=0,
cyclicalties=0)}{A special-purpose term equivalent to a linear
combination of \code{\link[ergm:edges-ergmTerm]{edges}},
\code{\link[ergm:mutual-ergmTerm]{mutual}}, \code{\link[ergm:transitiveties-ergmTerm]{transitiveties}}, and
\code{\link[ergm:cyclicalties-ergmTerm]{cyclicalties}}, to house the network-size
adjustment offset. This term is added to the model automatically
and should not be used in the model formula directly.  } } }

\item{ergm:}{
\itemize{
\item \code{offset}
\item \code{edges}
\item \code{nodecov}
\item \code{nodefactor}
\item \code{nodematch}
\item \code{nodemix}
\item \code{absdiff}
\item \code{absdiffcat}
\item \code{degree}
\item \code{degrange}
\item \code{concurrent}
\item \code{concurrentties}
\item \code{degree1.5}
\item \code{transitiveties}
\item \code{cyclicalties}
\item \code{esp}
\item \code{gwesp}
\item \code{gwdegree}
\item \code{mm}
\item \code{meandeg}*
}
}

\item{tergm:}{
\itemize{
\item \code{mean.age}*
}
}
}

Starred terms are \emph{nonscaling}, in that while they can be
evaluated, some inferential results and standard error calculation
methods may not be applicable.
}

\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}}
}
\keyword{models}
