% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/godfather.R
\name{ergm.godfather}
\alias{ergm.godfather}
\title{A function to apply a given series of changes to a network.}
\usage{
ergm.godfather(formula, changes = NULL, response = NULL,
  end.network = FALSE, stats.start = FALSE, verbose = FALSE,
  control = control.ergm.godfather())
}
\arguments{
\item{formula}{An \code{\link{ergm}}-style formula, with a
\code{\link{network}} on its LHS.}

\item{changes}{Either a matrix with three columns: tail, head, and
new value, describing the changes to be made; or a list of such
matrices to apply these changes in a sequence. For binary network
models, the third column may be omitted. In that case, the
changes are treated as toggles. Note that if a list is passed, it
must either be all of changes or all of toggles.}

\item{response}{Name of the edge attribute whose value is to be
modeled in the valued ERGM framework. Defaults to \code{NULL} for
simple presence or absence, modeled via a binary ERGM.}

\item{end.network}{Whether to return a network that
results. Defaults to \code{FALSE}.}

\item{stats.start}{Whether to return the network statistics at
\code{start} (before any changes are applied) as the first row of
the statistics matrix.  Defaults to \code{FALSE}, to produce
output similar to that of \code{\link[=simulate.ergm]{simulate}}
for ERGMs when \code{output="stats"}, where initial network's
statistics are not returned.}

\item{verbose}{Whether to print progress messages.}

\item{control}{A control list generated by
\code{\link{control.ergm.godfather}}.}
}
\value{
If \code{end.network==FALSE} (the default), an
\code{\link{mcmc}} object with the requested network statistics
associed with the network series produced by applying the
specified changes. Its \code{\link{mcmc}} attributes encode the
timing information: so \code{\link{start}(out)} gives the time
point associated with the first row returned, and
\code{\link{end}(out)} out the last. The "thinning interval" is
always 1.

If \code{end.network==TRUE}, return a \code{\link{network}} object,
representing the final network, with a matrix of statistics
described in the previous paragraph attached to it as an
\code{attr}-style attribute \code{"stats"}.
}
\description{
Gives the network a series of proposals it can't refuse. Returns the
statistics of the network, and, optionally, the final network.
}
\examples{
data(florentine)
ergm.godfather(flomarriage~edges+absdiff("wealth")+triangles,
               changes=list(cbind(1:2,2:3),
                            cbind(3,5),
                            cbind(3,5),
                            cbind(1:2,2:3)),
               stats.start=TRUE)
}
\seealso{
\code{\link[tergm:tergm.godfather]{tergm::tergm.godfather()}}, \code{\link[=simulate.ergm]{simulate.ergm()}},
\code{\link[=simulate.formula]{simulate.formula()}}
}
