% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.operator.R,
%   R/InitWtErgmTerm.operator.R
\name{Log-ergmTerm}
\alias{Log-ergmTerm}
\alias{InitErgmTerm.Log}
\alias{InitWtErgmTerm.Log}
\title{Take a natural logarithm of a network's statistic}
\usage{
# binary: Log(formula, log0=-1/sqrt(.Machine$double.eps))

# valued: Log(formula, log0=-1/sqrt(.Machine$double.eps))
}
\arguments{
\item{formula}{a one-sided \code{\link[=ergm]{ergm()}}-style formula with the terms to be evaluated}

\item{log0}{the value to be substituted for \code{log(0)}}
}
\description{
Evaluate the terms specified in \code{formula} and takes a natural (base \eqn{e} ) logarithm of them. Since an ERGM statistic must be finite, \code{log0} specifies the value to be substituted for \code{log(0)} . The default value seems reasonable for most purposes.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.
}
\concept{operator}
