% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{extract.ergmito}
\alias{extract.ergmito}
\title{Extract function to be used with the \code{texreg} package.}
\usage{
extract.ergmito(
  model,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.nnets = TRUE,
  include.convergence = TRUE,
  ...
)
}
\arguments{
\item{model}{An object of class \code{ergmito}.}

\item{include.aic, include.bic, include.loglik}{See \link[texreg:extract]{texreg::extract}.}

\item{include.nnets}{Logical. When true, it adds the Number of networks used
to the list of gof statistics. This can be useful when running pooled models.}

\item{include.convergence}{Logical. When true it, adds the convergence value
of the \link[stats:optim]{stats::optim} function (0 means convergence).}

\item{...}{Further arguments passed to \link{summary.ergmito}.}
}
\description{
To be used with the \CRANpkg{texreg} package. This function can be used to
generate nice looking tables of ERGMitos estimates.
}
\examples{

library(texreg)
data(fivenets)
ans <- ergmito(fivenets ~ edges + nodematch("female"))
screenreg(ans)

}
