% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_intervals.R
\name{df_intervals}
\alias{as.df_intervals}
\alias{df_intervals}
\alias{is.df_intervals}
\title{Data Frames of Intervals}
\usage{
df_intervals(distributions, errs)

as.df_intervals(x)

is.df_intervals(x)
}
\arguments{
\item{distributions}{vector containing the names of the distribution
correspondind to each error.}

\item{errs}{vector of errors associated to intervals built under
a particular distribution assumption indicated by 'distributions'.}

\item{x}{an R object.}
}
\value{
\code{df_intervals} returns an object of class
\code{c("df_intervals", "data.frame")} with information regarding the error of
intervals built under different distribution assumptions.

\code{as.df_intervals} returns an object of class
\code{c("df_intervals",class(x))} with information contained in x if possible.
Returns x otherwise.

\code{is.df_intervals} returns TRUE if x is an R object with
\code{"df_intervals"} as one of its classes. FALSE otherwise.
}
\description{
\code{df_intervals} creates an object of class
 \code{c("df_intervals", "data.frame")}.

\code{as.df_intervals} attempts to coerce its argument \code{x} into an
object of class \code{c("df_intervals", class(x))}. If this is not possible
\code{x} is returned unchanged.

\code{is.df_intervals} returns TRUE if x is an R object with
\code{"df_intervals"} as one of its classes. It returns FALSE otherwise.
}
\examples{
df_intervals("l",0.1)

df_intervals(c("l","lm","n","nm","b","w"),rep(0.1,6))


df<-data.frame(distribution=rnorm(1000),error=rnorm(1000))
as.df_intervals(df)

v<-c("a","b")
as.df_intervals(v)


df<-data.frame(distribution=rnorm(1000),error=rnorm(1000))
is.df_intervals(df)
res<-as.df_intervals(df)
is.df_intervals(res)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Prada, Jesus, and Jose Ramon Dorronsoro. "SVRs and Uncertainty Estimates in Wind 
Energy Prediction." Advances in Computational Intelligence. Springer International 
Publishing, 2015. 564-577,

with theoretical background for this package is provided below.

\url{http://link.springer.com/chapter/10.1007/978-3-319-19222-2_47}
}

