% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locate-errors.R
\name{locate_errors}
\alias{locate_errors}
\alias{locate_errors,data.frame,validator-method}
\alias{locate_errors,data.frame,ErrorLocalizer-method}
\title{Find errors in data}
\usage{
locate_errors(
  data,
  x,
  ...,
  cl = NULL,
  Ncpus = getOption("Ncpus", 1),
  timeout = 60
)

\S4method{locate_errors}{data.frame,validator}(
  data,
  x,
  weight = NULL,
  ref = NULL,
  ...,
  cl = NULL,
  Ncpus = getOption("Ncpus", 1),
  timeout = 60
)

\S4method{locate_errors}{data.frame,ErrorLocalizer}(
  data,
  x,
  weight = NULL,
  ref = NULL,
  ...,
  cl = NULL,
  Ncpus = getOption("Ncpus", 1),
  timeout = 60
)
}
\arguments{
\item{data}{data to be checked}

\item{x}{validation rules or errorlocalizer object to be used for finding
possible errors.}

\item{...}{optional parameters that are passed to \code{\link[lpSolveAPI:lp.control]{lpSolveAPI::lp.control()}} (see details)}

\item{cl}{optional parallel / cluster.}

\item{Ncpus}{number of nodes to use. See details}

\item{timeout}{maximum number of seconds that the localizer should use per record.}

\item{weight}{\code{numeric} optional weight specification to be used in the
error localization (see \code{\link[=expand_weights]{expand_weights()}}).}

\item{ref}{\code{data.frame} optional reference data to be used in the rules checking}
}
\value{
\code{\link[=errorlocation-class]{errorlocation-class()}} object describing the errors found.
}
\description{
Find out which fields in a data.frame are "faulty" using validation rules
This method returns found errors, according to the specified method \code{x}.
Use method \code{\link[=replace_errors]{replace_errors()}}, to automatically remove these errors.
`
}
\details{
Use an \code{Inf} \code{weight} specification to fixate variables that can not be changed.
See \code{\link[=expand_weights]{expand_weights()}} for more details.

\code{locate_errors} uses lpSolveAPI to formulate and solves a mixed integer problem.
For details see the vignettes.
This solver has many options:  \link[lpSolveAPI:lp.control.options]{lpSolveAPI::lp.control.options}. Noteworthy
options to be used are:
\itemize{
\item \code{timeout}: restricts the time the solver spends on a record (seconds)
\item \code{break.at.value}: set this to minimum weight + 1 to improve speed.
\item \code{presolve}: default for errorlocate is "rows". Set to "none" when you have
solutions where all variables are deemed wrong.
}

\code{locate_errors} can be run on multiple cores using R package \code{parallel}.
\itemize{
\item The easiest way to use the parallel option is to set \code{Ncpus} to the number of
desired cores, @seealso \code{\link[parallel:detectCores]{parallel::detectCores()}}.
\item Alternatively one can create a cluster object (\code{\link[parallel:makeCluster]{parallel::makeCluster()}})
and use \code{cl} to pass the cluster object.
\item Or set \code{cl} to an integer which results in \code{\link[parallel:mclapply]{parallel::mclapply()}}, which only works
on non-windows.
}
}
\examples{
rules <- validator( profit + cost == turnover
                  , cost >= 0.6 * turnover # cost should be at least 60\% of turnover
                  , turnover >= 0 # can not be negative.
                  )
data <- data.frame( profit   = 755
                  , cost     = 125
                  , turnover = 200
                  )
le <- locate_errors(data, rules)

print(le)
summary(le)

v_categorical <- validator( branch \%in\% c("government", "industry")
                          , tax \%in\% c("none", "VAT")
                          , if (tax == "VAT") branch == "industry"
)

data <- read.csv(text=
"   branch, tax
government, VAT
industry  , VAT
", strip.white = TRUE)
locate_errors(data, v_categorical)$errors

v_logical <- validator( citizen \%in\% c(TRUE, FALSE)
                      , voted \%in\% c(TRUE, FALSE)
                      ,  if (voted == TRUE) citizen == TRUE
                      )

data <- data.frame(voted = TRUE, citizen = FALSE)
locate_errors(data, v_logical, weight=c(2,1))$errors

# try a condinational rule
v <- validator( married \%in\% c(TRUE, FALSE)
              , if (married==TRUE) age >= 17
              )
data <- data.frame( married = TRUE, age = 16)
locate_errors(data, v, weight=c(married=1, age=2))$errors


# different weights per row
data <- read.csv(text=
"married, age
    TRUE,  16
    TRUE,  14
", strip.white = TRUE)

weight <- read.csv(text=
"married, age
       1,   2
       2,   1
", strip.white = TRUE)

locate_errors(data, v, weight = weight)$errors

# fixate / exclude a variable from error localiziation
# using an Inf weight
weight <- c(age = Inf)
locate_errors(data, v, weight = weight)$errors
}
\seealso{
Other error finding: 
\code{\link{errorlocation-class}},
\code{\link{errors_removed}()},
\code{\link{expand_weights}()},
\code{\link{replace_errors}()}
}
\concept{error finding}
