% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED2_SSR.boundary}
\alias{AED2_SSR.boundary}
\title{Calculate the futility and efficacy stopping boundaries of the Adaptive
  Enrichment Design (Strategy 2) with Sample Size Re-estimation Procedure}
\usage{
AED2_SSR.boundary(rho, alpha, pstar, epsilon)
}
\arguments{
\item{rho}{The proportion of subgroup 1}

\item{alpha}{The overall Type I error rate}

\item{pstar}{The \code{(1 - power)} of accepting the null hypothesis at the
interim analysis.}

\item{epsilon}{The threshold of difference between the subgroup-specific test
statistics}
}
\value{
A list contains
\itemize{
  \item upper.boundary The upper and efficacy stopping boundary
  \item lower.boundary The lower and futility stopping boundary
}
}
\description{
The \code{AED2_SSR.boundary()} is used to calculate the futility
  and efficacy stopping boundaries of the Adaptive Enrichment Design (strategy 2)
  with Sample Size Re-estimation Procedure. In the AED2-SSR design, an
  \eqn{\epsilon}-rule is introduced to select the subgroup with larger test
  statistic. In practice, the value of \eqn{\epsilon} should be calibrated to
  fit the requirement of the trial.
}
\examples{
rho <- 0.5
alpha <- 0.05
pstar <- 0.15
epsilon <- 0.5
AED2_SSR.boundary(rho = rho, alpha = alpha, pstar = pstar, epsilon = epsilon)
}
