% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ESA_BCV.R
\name{PseudoInv}
\alias{PseudoInv}
\title{Moore-Penrose Pseudo Inverse of A Matrix}
\usage{
PseudoInv(Y, k, svd.method = "fast")
}
\arguments{
\item{Y}{the given matrix}

\item{k}{the given rank}

\item{svd.method}{either "fast", "propack" or "standard".
"fast" is using the \code{\link[corpcor]{fast.svd}} function in package corpcor to compute SVD, "propack" is using the \code{\link[svd]{propack.svd}} to compute SVD and "standard"
is using the \code{\link[base]{svd}} function in the base package. Because of PROPACK
issues, "propack" fails for some matrices, and when that happens,
the function will use "fast" to
compute the SVD of that matrix instead. Default method is "fast".}
}
\value{
A pseudo-inverse matrix of rank \code{k}
}
\description{
Calculate the Moore-Penrose pseudo inverse of matrix \code{Y} up to a given rank
}
\details{
This function does similar things as \code{\link[MASS]{ginv}} in package MASS while controls
the rank.
}

