% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_d2etasq.R
\name{esc_d2etasq}
\alias{esc_d2etasq}
\title{Convert effect size d into Eta Squared}
\usage{
esc_d2etasq(d, se, v, grp1n, grp2n, info = NULL, study = NULL)
}
\arguments{
\item{d}{The effect size \code{d}.}

\item{se}{The standard error of \code{d}. One of \code{se} or \code{v}
must be specified.}

\item{v}{The variance of \code{d}. One of \code{se} or \code{v} must be
specified.}

\item{grp1n}{Treatment group sample size.}

\item{grp2n}{Control group sample size.}

\item{info}{String with information on the transformation. Used for the
print-method. Usually, this argument can be ignored}

\item{study}{Optional string with the study name. Using \code{\link{combine_esc}} or
\code{as.data.frame} on \code{esc}-objects will add this as column
in the returned data frame.}
}
\value{
The effect size \code{es}, the standard error \code{se}, the variance
        of the effect size \code{var}, the lower and upper confidence limits
        \code{ci.lo} and \code{ci.hi}, the weight factor \code{w} and the
        total sample size \code{totaln}.
}
\description{
Compute effect size Eta Squared from effect size \code{d}.
}
\examples{
# d to eta squared
esc_d2etasq(d = 0.7, se = 0.5, grp1n = 70, grp2n = 80)

}
\references{
Cohen J. 1988. Statistical Power Analysis for the Behavioral Sciences. 2nd ed. Hillsdale, NJ: Erlbaum
}
