% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{mean_prob_tox}
\alias{mean_prob_tox}
\title{Mean toxicity rate at each dose.}
\usage{
mean_prob_tox(x, ...)
}
\arguments{
\item{x}{Object of class \code{\link{selector}}}

\item{...}{arguments passed to other methods}
}
\value{
a numerical vector
}
\description{
Get the estimated mean toxicity rate at each dose under investigation. This
is a set of modelled statistics. The underlying models estimate toxicity
probabilities in different ways. If no model-based estimate of the mean is
available, this function will return a vector of NAs.
}
\examples{
# CRM example
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25
outcomes <- '1NNN 2NTN'
fit <- get_dfcrm(skeleton = skeleton, target = target) \%>\% fit(outcomes)
fit \%>\% mean_prob_tox()
}
