% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_magnitude.R
\name{plot_correlation}
\alias{plot_correlation}
\title{Plot an estimated Pearson's r value}
\usage{
plot_correlation(
  estimate,
  error_layout = c("halfeye", "eye", "gradient", "none"),
  error_scale = 0.3,
  error_normalize = c("groups", "all", "panels"),
  rope = c(NA, NA),
  ggtheme = NULL
)
}
\arguments{
\item{estimate}{\itemize{
\item An esci_estimate object generated by
\code{\link[=estimate_r]{estimate_r()}}
}}

\item{error_layout}{\itemize{
\item Optional; One of 'halfeye', 'eye', 'gradient' or 'none'
for how expected sampling error of the measure of central tendency should
be displayed.  \strong{Caution - the displayed error distributions do not seem
correct yet}
}}

\item{error_scale}{\itemize{
\item Optional real number > 0 specifying width of the expected
sampling error visualization; default is 0.3
}}

\item{error_normalize}{\itemize{
\item Optional; One of 'groups' (default), 'all', or
'panels' specifying how width of expected sampling error distributions
should be calculated.
}}

\item{rope}{\itemize{
\item Optional two-item vector specifying a region of practical
equivalence (ROPE) to be highlighted on the plot.  For a point null
hypothesis, pass the same value (e.g. c(0, 0) to test a point null of
exactly 0); for an interval null pass ascending values (e.g. c(-1, 1))
}}

\item{ggtheme}{\itemize{
\item Optional ggplot2 theme object to control overall styling;
defaults to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic()}}
}}
}
\value{
Returns a ggplot object
}
\description{
\code{plot_correlation} creates a ggplot2 plot suitable for visualizing an
estimate correlation between two continuous variables (Pearson's \emph{r}). This
function can be passed an esci_estimate object generated by
\code{\link[=estimate_r]{estimate_r()}}
}
\details{
This function was developed primarily for student use within jamovi when
learning along with the text book Introduction to the New Statistics, 2nd
edition (Cumming & Calin-Jageman, 2024).

Expect breaking changes as this function is improved for general use.  Work
still do be done includes:
\itemize{
\item Revise to avoid deprecated ggplot features
\item Revise for consistent ability to control aesthetics and consistent
layer names
}
}
\examples{
# From raw data
data("data_thomason_1")

estimate_from_raw <- esci::estimate_r(
  esci::data_thomason_1,
  Pretest,
  Posttest
)

# To visualize the value of r
myplot_correlation <- esci::plot_correlation(estimate_from_raw)

# To visualize the data (scatterplot) and use regression to obtain Y' from X
myplot_scatter_from_raw <- esci::plot_scatter(estimate_from_raw, predict_from_x = 10)

# To evaluate a hypothesis (interval null from -0.1 to 0.1):
res_htest_from_raw <- esci::test_correlation(
  estimate_from_raw,
  rope = c(-0.1, 0.1)
)


# From summary data
estimate_from_summary <- esci::estimate_r(r = 0.536, n = 50)

# To visualize the value of r
myplot_correlation_from_summary <- esci::plot_correlation(estimate_from_summary)

# To evaluate a hypothesis (interval null from -0.1 to 0.1):
res_htest_from_summary <- esci::test_correlation(
  estimate_from_summary,
  rope = c(-0.1, 0.1)
)


}
