% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_motion.R
\name{signal_motion}
\alias{signal_motion}
\title{Calculate particle motion parameters}
\usage{
signal_motion(data, time, dt, window, step, order = "xyz")
}
\arguments{
\item{data}{\code{List}, \code{data frame} or \code{matrix}, seismic
componenents to be processed. If \code{data} is a matrix, the components 
must be organised as columns. Also, \code{data} can be a list of 
\code{eseis} objects.}

\item{time}{\code{POSIXct} vector, time vector corresponding to the 
seismic signal components. If omitted, a synthetic time vector will 
be generated. If omitted, the sampling period (\code{dt}) must be 
provided.}

\item{dt}{\code{Numeric} value, sampling period. Only needed if 
\code{time} is omitted or if \code{data} is no \code{eseis} object.}

\item{window}{\code{Numeric} value, time window length (given as 
number of samples) used to calculate the particle motion parameters. 
If value is even, it will be set to the next smaller odd value. If 
omitted, the window size is set to 1 percent of the time series length by
default.}

\item{step}{\code{Numeric} value, step size (given as number of samples), 
by which the window is shifted over the data set. If omitted, the step 
size is set to 50 percent of the window size by default.}

\item{order}{\code{Character} value, order of the seismic components. 
Describtion must contain the letters \code{"x"},\code{"y"} and
\code{"z"} in the order according to the input data set. Default is 
\code{"xyz"} (NS-EW-vertical).}
}
\value{
A List object with eigenvalue ratios (\code{eigen}), 
azimuth (\code{azimuth}) and inclination (\code{inclination}) as well
as the corresponding time vector for these values.
}
\description{
The function calculates from a data set of three seismic 
components of the same signal the following particle motion 
paramters using a moving window approach: horizontal-vertical 
eigenvalue ratio, azimuth and inclination.
}
\details{
The function code is loosely based on the function GAZI() from 
the package RSEIS with removal of unnecessary content and updated 
or rewritten loop functionality.
}
\examples{
## load example data set
data(earthquake)

## filter seismic signals
s <- eseis::signal_filter(data = s, 
                          dt = 1/200, 
                          f = c(1, 3))

## integrate signals to get displacement
s_d <- eseis::signal_integrate(data = s, dt = 1/200)

## calculate particle motion parameters
pm <- signal_motion(data = s_d, 
                    time = t, 
                    dt = 1 / 200,
                    window = 100, 
                    step = 10)
                    
## plot function output
par_original <- par(no.readonly = TRUE)
par(mfcol = c(2, 1))

plot(x = t, y = s$BHZ, type = "l")
plot(x = pm$time, y = pm$azimuth, type = "l")

par(par_original)

}
\author{
Michael Dietze
}
\keyword{eseis}
