% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_sac.R
\name{write_sac}
\alias{write_sac}
\title{Write seismic traces as sac file to disk.}
\usage{
write_sac(data, file, time, component, unit, station, location, network, dt,
  autoname = FALSE, parameters, biglong = FALSE)
}
\arguments{
\item{data}{\code{eseis} object or \code{numeric} vector, data set to 
be processed. Most other arguments can be omitted if \code{data} is an
\code{eseis} object.}

\item{file}{\code{Character} scalar, sac file name with extension.}

\item{time}{\code{POSIXct} vector, time vector corresponding to the 
seismic trace. Alternatively, the start time stamp can be provided as
\code{POSIXct} value and a value for \code{dt} must be given.}

\item{component}{\code{Character} value, component ID, optional.}

\item{unit}{\code{Character} value, unit of the signal, optional. One out
of \code{"unknown"}, \code{"displacement"}, \code{"velocity"}, 
\code{"volts"}, \code{"acceleration"}. Default is \code{"unknown"}.}

\item{station}{\code{Character} value, station ID, optinal.}

\item{location}{\code{Character} vector of length four, station location 
data (latitude, longitude, elevation, depth), optional.}

\item{network}{\code{Character} value, network ID, optional.}

\item{dt}{\code{Numeric} value, sampling period. Only needed if no time
vector is provided.}

\item{autoname}{\code{Logical} value, option to let the function generate 
the file name automatically. Default is \code{FALSE}.}

\item{parameters}{\code{Data frame} sac parameter list, as obtained from
\code{list_sacparameters}. Allows user-specific modifications. If this 
data frame is provided, it overrides all other arguments.}

\item{biglong}{\code{Logical} value, biglong option, default is 
\code{FALSE}}
}
\value{
A binary file written to disk.
}
\description{
This function converts seismic traces to sac files and writes them to disk.
}
\details{
For description of the sac file format see
https://ds.iris.edu/files/sac-manual/manual/file_format.html. Currently the 
following parameters are not supported when writing the sac file: 
LAT, LON, ELEVATION, NETWORK.
}
\examples{

\dontrun{
## load example data 
data("rockfall")

## write as sac file
write_sac(data = rockfall_eseis)
          
}

}
\author{
Michael Dietze
}
