% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_correlogram.R
\name{plot_correlogram}
\alias{plot_correlogram}
\title{Plot a correlogram from noise cross correlation analysis}
\usage{
plot_correlogram(data, agg = c(1, 1), legend = TRUE, keep_par = FALSE, ...)
}
\arguments{
\item{data}{\code{List} object, spectrogram to be plotted. Must be output
of \code{ncc_correlate()} or of equivalent structure.}

\item{agg}{\code{Integer} vector of length two, factors of image 
aggregation, i.e. in time and lag dimension. Useful to decrease 
image size. Default is \code{c(1, 1)} (no aggregation).}

\item{legend}{\code{Logical} value, option to add colour bar legend. Legend
label can be changed by \code{zlab}.}

\item{keep_par}{\code{Logical} value, option to omit resetting plot 
parameters after function execution. Useful for adding further data to the 
plot. Default is \code{FALSE} (parameters are reset to original values).}

\item{\dots}{Additional arguments passed to the plot function.}
}
\value{
Graphic output of a correlogram.
}
\description{
The function uses the output of \code{ncc_correlate()} to show an  
image plot of a noise cross correlation analysis.
}
\examples{

\dontrun{
  
  ## calculate correlogram
  cc <- ncc_correlate(start = "2017-04-09 00:30:00", 
                       stop = "2017-04-09 01:30:00", 
                       ID = c("RUEG1", "RUEG2"), 
                       component = c("Z", "Z"), 
                       dir = paste0(system.file("extdata", 
                                    package = "eseis"), "/"), 
                       window = 600, 
                       overlap = 0, 
                       lag = 20, 
                       f = c(0.05, 0.1), 
                       sd = 1)
                       
   ## explicit plot function call with adjusted resolution
   plot_correlogram(data = cc, agg = c(2, 5))
   
   ## define plot colour scale
   cls <- colorRampPalette(colors = c("brown", "white", "green"))
   
   ## simple function call with user-defined colour scale
   plot(cc, col = cls(100))
}

}
\seealso{
\code{\link{ncc_correlate}}
}
\author{
Michael Dietze
}
\keyword{eseis}
