% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasts.R
\name{predict.esemifar}
\alias{predict.esemifar}
\title{ESEMIFAR Prediction Method}
\usage{
\method{predict}{esemifar}(
  object,
  n.ahead = 5,
  alpha = c(0.95, 0.99),
  method = c("norm", "boot"),
  bootMethod = c("simple", "advanced"),
  npaths = 5000,
  quant.type = 8,
  boot_progress = TRUE,
  expo = FALSE,
  trend_extrap = c("linear", "constant"),
  future = TRUE,
  num_cores = future::availableCores() - 1,
  ...
)
}
\arguments{
\item{object}{an object returned by either \code{\link{tsmoothlm}} or
\code{\link{esemifar}}.}

\item{n.ahead}{a single numeric value that represents the forecasting horizon.}

\item{alpha}{a numeric vector with confidence levels for the forecasting
intervals; the default \code{c(0.95, 0.99)} represents 95-percent and
99-percent forecasting interval bounds that will be computed.}

\item{method}{whether to obtain the forecasting intervals under the
normality assumption (\code{"norm"}) or via a bootstrap (\code{"boot"}).}

\item{bootMethod}{only for \code{method = "boot"}: whether to simulate
future paths only (\code{"simple"}) or whether to
re-estimate the FARIMA model for the re-sampled series and to then obtain
simulated predictive roots (\code{"advanced"}).}

\item{npaths}{only for \code{method = "boot"}: the number of bootstrap
iterations.}

\item{quant.type}{only for \code{method = "boot"}: the quantile type as
in the argument \code{type} of the function \code{\link[stats]{quantile}}.}

\item{boot_progress}{only for \code{method = "boot"}: whether to show a
progress bar in the console.}

\item{expo}{whether to exponentiate all results at the end.}

\item{trend_extrap}{how to extrapolate the estimated trend into the future:
linearly (\code{"linear"}) or constantly (\code{"constant"}).}

\item{future}{only for \code{method = "boot"}: use parallel programming
for the bootstrap via the \code{future} framework?}

\item{num_cores}{only for \code{method = "boot"} and \code{future = TRUE}:
how many cores to use in the parallel programming.}

\item{...}{no purpose; for compatibility only.}
}
\value{
The function returns a list of class \code{"esemifar"} with elements
\code{nonpar_model} and \code{par_model}.

A list with various elements is returned.
\describe{
\item{obs}{the observed series.}
\item{mean}{the point forecasts.}
\item{lower}{the lower bounds of the forecasting intervals.}
\item{upper}{the upper bounds of the forecasting intervals.}
\item{model}{the fitted ESEMIFAR model object.}
\item{level}{the confidence levels for the forecasting intervals.}
}
}
\description{
Point and interval forecasts (under the normality assumption or via a
bootstrap) for fitted ESEMIFAR models.
}
\details{
Produce point and interval forecasts based on ESEMIFAR models. Throughout,
the infinite-order AR-representation of the parametric FARIMA part is considered
to produce point forecasts and future paths of the series. The trend is usually
extrapolated linearly (or constantly as an alternative).
}
\examples{
lgdp <- log(esemifar::gdpG7$gdp)
est <- tsmoothlm(lgdp, pmax = 1, qmax = 1)
# Under normality
fc <- predict(est, n.ahead = 10, method = "norm", expo = TRUE)
fc$mean
fc$lower
fc$upper

}
\author{
\itemize{
\item Dominik Schulz (Scientific Employee) (Department of Economics,
Paderborn University), \cr
Author
}
}
