% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dicom_parser.R
\name{dicom.parser}
\alias{dicom.parser}
\title{Conversion of DICOM raw data into a dataframe or a list of DICOM TAG information}
\usage{
dicom.parser(
  dicom.raw.data,
  as.txt = TRUE,
  try.parse = FALSE,
  txt.sep = "\\\\",
  txt.length = 100,
  tag.dictionary = dicom.tag.dictionary()
)
}
\arguments{
\item{dicom.raw.data}{Raw vector, representing the binary extraction of the DICOM file.}

\item{as.txt}{Boolean. If \code{as.txt = TRUE}, the function returns a
dataframe, a list otherwise.}

\item{try.parse}{Boolean. If \code{TRUE}, the tag with unknown DICOM VR
(value representation) is converted into string if possible.}

\item{txt.sep}{String. Used if \code{as.txt = TRUE}. Separator of the tag value elements.}

\item{txt.length}{Positive integer. Used if \code{as.txt = TRUE}. Maximum number
of letters in the representation of the TAG value.}

\item{tag.dictionary}{Dataframe, by default equal to \link[espadon]{dicom.tag.dictionary},
whose structure it must keep. This dataframe is used to parse DICOM files.}
}
\value{
Returns a list of elements or a dataframe, depending on  \code{as.list}.

If it returns a dataframe, the columns are names TAG, VR (value representation),
VM (value multiplicity), loadsize and Value. The field \code{$Value} is a string
representation of the true value.

If it returns a list, each of its elements, named by a TAG, is either
a vector or a string, depending of the TAG included in \code{dicom.raw.data}.
}
\description{
The \code{dicom.parser} function creates a dataframe or a list from
DICOM raw data. The created dataframe or list provides information about the
content of the DICOM TAGs included in the raw data.
}
\examples{
# content of the dummy raw data toy.dicom.raw (), as a list.
L <- dicom.parser (toy.dicom.raw (), as.txt = FALSE)
L[1:10]

# content of the dummy raw data toy.dicom.raw (), as a dataframe.
L <- dicom.parser (toy.dicom.raw (), as.txt = TRUE)
str (L)
}
\seealso{
\link[espadon]{dicom.raw.data.loader}, \link[espadon]{dicom.tag.parser}
}
