% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_equal.R
\name{grid.equal}
\alias{grid.equal}
\title{Comparison of the grids of two volume objects}
\usage{
grid.equal(vol1, vol2)
}
\arguments{
\item{vol1, vol2}{"volume" class objects}
}
\value{
Returns \code{TRUE} if the 2 volumes share the same grid.
}
\description{
The \code{grid.equal} function checks that two volumes share the
same grid, i.e. the same frame of reference, the same origin point, and the
same dx, dy, dz steps.
}
\examples{
# loading of toy-patient objects
patient <- toy.load.patient (modality = c ("ct","mr","rtdose"), roi.name = "", 
                             dxyz = c (4, 4, 4), beam.nb = 1)

# Comparison of the grids
grid.equal (patient$rtdose[[1]], patient$ct[[1]])
grid.equal (patient$mr[[1]], patient$ct[[1]])
}
