% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_3D_sections.R
\name{display.3D.sections}
\alias{display.3D.sections}
\title{Display 3D sections of a patient}
\usage{
display.3D.sections(
  obj,
  cross.pt = c(0, 0, 0),
  display.ref = obj$ref.pseudo,
  T.MAT = NULL,
  col = grey.colors(10, start = 0, end = 1, alpha = c(rep(0, 1), rep(1, 9))),
  breaks = NULL,
  trans = TRUE,
  sagi = TRUE,
  front = TRUE,
  border = TRUE,
  border.col = "#379DA2",
  ...
)
}
\arguments{
\item{obj}{"volume" class object to display. See \link[espadon]{espadon.class} for
class definitions.}

\item{cross.pt}{Vector of x, y, z coordinates, representing the cross point of the 3 planes in display.plane.}

\item{display.ref}{Character string. Pseudonym of the frame of reference used for display.}

\item{T.MAT}{"t.mat" class object, created by \link[espadon]{load.patient.from.Rdcm} or
\link[espadon]{load.T.MAT}. If \code{T.MAT} is \code{NULL}, \code{obj} must be
displayed in \code{display.ref = obj$ref.pseudo}.}

\item{col}{Vector, representing the color palette of the image. Transparent
colors are not represented.}

\item{breaks}{One of :
\itemize{
\item \code{NULL} : the minimum and the maximum value of the \code{obj} define the range.
\item Vector giving the breakpoints of each color.
}}

\item{trans}{Boolean. If \code{TRUE} (default), the transverse view is displayed.}

\item{sagi}{Boolean. If \code{TRUE} (default), the sagittal view is displayed.}

\item{front}{Boolean. If \code{TRUE} (default), the frontal view is displayed.}

\item{border}{Boolean. If \code{TRUE} (default), the borders of the planes are displayed}

\item{border.col}{Color of planes borders}

\item{...}{Argument for deprecated arguments}
}
\value{
Returns a display of transverse, sagittal and frontal views of \code{obj}
at \code{cross.pt}  in the current \pkg{RGL} window if it exists, in a new
window otherwise. Palette colors are managed by \code{col} and \code{breaks}.
}
\description{
The \code{display.3D.sections} function displays transverse,
sagittal and frontal views at a point in 3D.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = "ct", dxyz = rep (step, 3))
CT <- patient$ct[[1]]

library (rgl)
open3d()
display.3D.sections(CT, cross.pt= c(0, 50, 80),
                    col= pal.RVV(200, alpha= c(rep(0,90), rep(1,110))))
}
