% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{ggplot-output}
\alias{ggplot-output}
\alias{ggplot_output}
\alias{downloads_labels}
\alias{render_ggplot}
\title{Render \code{ggplot} module}
\usage{
ggplot_output(
  id,
  width = "100\%",
  height = "400px",
  downloads = downloads_labels(),
  ...
)

downloads_labels(
  label = ph("download-simple"),
  png = tagList(ph("image"), "PNG"),
  pdf = tagList(ph("file-pdf"), "PDF"),
  svg = tagList(ph("browsers"), "SVG"),
  jpeg = tagList(ph("image"), "JPEG"),
  pptx = tagList(ph("projector-screen"), "PPTX"),
  more = tagList(ph("gear"), i18n("More options"))
)

render_ggplot(
  id,
  expr,
  ...,
  env = parent.frame(),
  quoted = FALSE,
  filename = "export-ggplot"
)
}
\arguments{
\item{id}{Module ID.}

\item{width}{Width of the plot.}

\item{height}{Height of the plot.}

\item{downloads}{Labels for export options, use \code{downloads_labels}.}

\item{...}{Parameters passed to \code{\link[shiny:plotOutput]{shiny::plotOutput()}} (\code{ggplot_output}) or \code{\link[shiny:renderPlot]{shiny::renderPlot()}} (\code{render_ggplot}).}

\item{label}{Main label for export button}

\item{png, pdf, svg, jpeg, pptx}{Labels to display in
export menu, use \code{NULL} to disable specific format.}

\item{more}{Label for "more" button, allowing to launch export modal.}

\item{expr}{An expression that generates a \code{ggplot} object.}

\item{env}{The environment in which to evaluate expression.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}

\item{filename}{A string of the filename to export WITHOUT extension,
it will be added according to type of export.}
}
\value{
Server-side, a \code{reactiveValues} with the plot.
}
\description{
Display a plot on the client and allow to download it.
}
\examples{

library(shiny)
library(ggplot2)
library(esquisse)


ui <- fluidPage(
  tags$h2("ggplot output"),
  selectInput("var", "Variable:", names(economics)[-1]),
  ggplot_output("MYID", width = "600px")
)

server <- function(input, output, session) {
  
  render_ggplot("MYID", {
    ggplot(economics) + 
      geom_line(aes(date, !!sym(input$var))) + 
      theme_minimal() + 
      labs(
        title = "A cool chart made with ggplot2",
        subtitle = "that you can export in various format"
      )
  })
}

if (interactive())
  shinyApp(ui, server)
}
