% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funs.R
\name{seg_match}
\alias{seg_match}
\title{Match segments on a plot}
\usage{
seg_match(x, y, ...)
}
\arguments{
\item{x}{The x-coordinate.}

\item{y}{The y-coordinate.}

\item{...}{Additional parameters passed to \link[graphics]{segments}. Note
that whatever parameters are passed here are also passed to 
\link[graphics]{points} (e.g., \code{col}).}
}
\description{
Given an x and y coordinate, this function will produce segments that 
extend from -1 to the corresponding xy intersection, with a point
at the intersection.
}
\examples{
plot(1:10, (1:10)^2, type = "l")
seg_match(3, 9)
seg_match(c(6, 8), c(36, 64), 
	col = c("blue", "green"),
	pch = 21, 
	bg = c("blue", "green"), 
	lty = 3)
}
