% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_void.R
\name{drop_void}
\alias{drop_void}
\title{drop_void: Remove Void Values from a Vector or List}
\usage{
drop_void(x, include_na = TRUE, include_null = TRUE, include_empty_str = TRUE)
}
\arguments{
\item{x}{A vector or list.}

\item{include_na}{Logical. Remove \code{NA} if TRUE. Default: TRUE.}

\item{include_null}{Logical. Remove \code{NULL} if TRUE. Default: TRUE.}

\item{include_empty_str}{Logical. Remove \code{""} if TRUE. Default: TRUE.}
}
\value{
A cleaned vector or list of the same type as input, with void values removed.
}
\description{
Removes elements from a vector or list that are considered "void":
\code{NA}, \code{NULL}, and empty strings (`"""). Each can be toggled via parameters.
}
\examples{
drop_void(c("apple", "", NA, "banana"))
drop_void(list("A", NA, "", NULL, "B"))
drop_void(c("", NA), include_na = FALSE)
}
